/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript;

import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.SQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.sqltofile.SQLToFileHandler;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateDataScriptAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateDataScriptOfCurrentSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateFileOfCurrentSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateFileOfSelectedTablesAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateInsertStatementsFileOfCurrentSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateInsertStatementsFileOfSelectedTablesSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateSelectScriptAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateTableOfCurrentSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateTableScriptAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateTemplateDataScriptAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.DropTableScriptAction;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLScriptMenuFactory {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLScriptMenuFactory.class);

    public static JMenu getObjectTreeMenu(DatabaseObjectType databaseObjectType) {
        if (databaseObjectType != DatabaseObjectType.TABLE && databaseObjectType != DatabaseObjectType.VIEW) {
            throw new IllegalStateException("Call for DatabaseObjectType.TABLE and DatabaseObjectType.VIEW only.");
        }
        IApplication app = Main.getApplication();
        ActionCollection coll = app.getActionCollection();
        SquirrelResources resources = Main.getApplication().getResources();
        JMenu menu = new JMenu(s_stringMgr.getString("SQLScriptMenuFactory.objecttree.menu.title"));
        resources.addToMenu(coll.get(CreateDataScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateTemplateDataScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateTableScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateSelectScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateInsertStatementsFileOfSelectedTablesSQLAction.class), menu);
        if (databaseObjectType == DatabaseObjectType.TABLE) {
            resources.addToMenu(coll.get(DropTableScriptAction.class), menu);
        }
        return menu;
    }

    public static Action getExportAction() {
        return Main.getApplication().getActionCollection().get(CreateFileOfSelectedTablesAction.class);
    }

    public static JMenu getSessionMenu() {
        IApplication app = Main.getApplication();
        ActionCollection coll = app.getActionCollection();
        SquirrelResources resources = Main.getApplication().getResources();
        JMenu menu = new JMenu(s_stringMgr.getString("SQLScriptMenuFactory.session.menu.title"));
        resources.addToMenu(coll.get(CreateDataScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateTemplateDataScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateTableScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateSelectScriptAction.class), menu);
        resources.addToMenu(coll.get(DropTableScriptAction.class), menu);
        resources.addToMenu(coll.get(CreateDataScriptOfCurrentSQLAction.class), menu);
        resources.addToMenu(coll.get(CreateInsertStatementsFileOfCurrentSQLAction.class), menu);
        resources.addToMenu(coll.get(CreateTableOfCurrentSQLAction.class), menu);
        resources.addToMenu(coll.get(CreateFileOfCurrentSQLAction.class), menu);
        return menu;
    }

    public static void addMenuItemsToSQLPanelApi(SQLPanelAPI sqlPanelAPI) {
        sqlPanelAPI.addSeparatorToSQLEntryAreaMenu();
        IApplication app = Main.getApplication();
        JMenuItem mnu = sqlPanelAPI.addToSQLEntryAreaMenu(app.getActionCollection().get(CreateTableOfCurrentSQLAction.class));
        app.getResources().configureMenuItem(app.getActionCollection().get(CreateTableOfCurrentSQLAction.class), mnu);
        mnu = sqlPanelAPI.addToSQLEntryAreaMenu(app.getActionCollection().get(CreateDataScriptOfCurrentSQLAction.class));
        app.getResources().configureMenuItem(app.getActionCollection().get(CreateDataScriptOfCurrentSQLAction.class), mnu);
        mnu = sqlPanelAPI.addToSQLEntryAreaMenu(app.getActionCollection().get(CreateInsertStatementsFileOfCurrentSQLAction.class));
        app.getResources().configureMenuItem(app.getActionCollection().get(CreateInsertStatementsFileOfCurrentSQLAction.class), mnu);
        mnu = sqlPanelAPI.addToSQLEntryAreaMenu(app.getActionCollection().get(CreateFileOfCurrentSQLAction.class));
        app.getResources().configureMenuItem(app.getActionCollection().get(CreateFileOfCurrentSQLAction.class), mnu);
        sqlPanelAPI.addSQLExecutionListener(new SQLToFileHandler(sqlPanelAPI.getSession(), sqlPanelAPI));
    }

    public static List<Action> getSessionToolbarActions() {
        ActionCollection coll = Main.getApplication().getActionCollection();
        return List.of(coll.get(CreateTableOfCurrentSQLAction.class), coll.get(CreateFileOfCurrentSQLAction.class));
    }

    public static List<Action> getSQLInternalFrameToolbarActions() {
        return SQLScriptMenuFactory.getSessionToolbarActions();
    }
}

