/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.sqltofile;

import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportProgressManager;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class ExportToFileHandler {
    private static final ILogger s_log = LoggerController.createLogger(ExportToFileHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportToFileHandler.class);
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private final ISession _session;
    private final ISQLPanelAPI _sqlPaneAPI;
    private boolean _abortExecution = false;

    public ExportToFileHandler(ISession session, ISQLPanelAPI sqlPaneAPI) {
        this._session = session;
        this._sqlPaneAPI = sqlPaneAPI;
    }

    public String exportToFile(String initialSql) {
        IQueryTokenizer queryTokenizer = this._session.getQueryTokenizer();
        queryTokenizer.setScriptToTokenize(initialSql);
        StringBuilder sqlsNotToWriteToFile = new StringBuilder();
        while (queryTokenizer.hasQuery()) {
            QueryHolder query = queryTokenizer.nextQuery();
            if (!ExportToFileHandler.willBeHandledByMe(query)) {
                sqlsNotToWriteToFile.append(query.getQuery());
                if (1 == queryTokenizer.getSQLStatementSeparator().length()) {
                    sqlsNotToWriteToFile.append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                    continue;
                }
                sqlsNotToWriteToFile.append(" ").append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                continue;
            }
            String sqlWithFilePrefix = query.getQuery().trim();
            int fileBeginMarkerPos = sqlWithFilePrefix.indexOf(39);
            if (-1 == fileBeginMarkerPos) {
                Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToFileHandler.noFileBeginMarker"));
                continue;
            }
            int fileEndMarkerPos = sqlWithFilePrefix.indexOf(39, fileBeginMarkerPos + 1);
            if (-1 == fileEndMarkerPos) {
                Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToFileHandler.noFileEndMarker"));
                continue;
            }
            String fileName = sqlWithFilePrefix.substring(fileBeginMarkerPos + 1, fileEndMarkerPos).trim();
            File file = new File(fileName);
            String sqlToWriteToFile = sqlWithFilePrefix.substring(fileEndMarkerPos + 1).trim();
            TableExportPreferences prefs = TableExportPreferencesDAO.createExportPreferencesForFile(fileName);
            this.callResultSetExport(prefs, file, sqlToWriteToFile);
            if (!this._abortExecution) continue;
            this._abortExecution = false;
            break;
        }
        this._sqlPaneAPI.getSQLEntryPanel().requestFocus();
        if (0 == sqlsNotToWriteToFile.length()) {
            return null;
        }
        return sqlsNotToWriteToFile.toString();
    }

    public static boolean containsMyMarker(String initialSqlString) {
        return null != initialSqlString && StringUtils.containsIgnoreCase((CharSequence)initialSqlString.trim(), (CharSequence)"@file");
    }

    public static boolean willBeHandledByMe(QueryHolder sql) {
        return null != sql && StringUtils.startsWithIgnoreCase((CharSequence)sql.getQuery().trim(), (CharSequence)"@file");
    }

    private void callResultSetExport(TableExportPreferences prefs, File file, String sqlToWriteToFile) {
        try {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("ExportToFileHandler.writing.file", file.getPath()));
            DialectType dialectType = DialectFactory.getDialectType(this._session.getMetaData());
            Connection con = this._session.getSQLConnection().getConnection();
            FileExportProgressManager fileExportProgressManager = new FileExportProgressManager(this._session, sqlToWriteToFile, () -> file);
            fileExportProgressManager.getOrCreateProgressCallback(() -> this.onModalProgressDialogIsDisplaying(prefs, file, sqlToWriteToFile, con, dialectType, fileExportProgressManager));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onModalProgressDialogIsDisplaying(TableExportPreferences prefs, File file, String sqlToWriteToFile, Connection con, DialectType dialectType, FileExportProgressManager fileExportProgressManager) {
        this._executorService.submit(() -> this.doWriteFile(prefs, file, sqlToWriteToFile, con, dialectType, fileExportProgressManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteFile(TableExportPreferences prefs, File file, String sqlToWriteToFile, Connection con, DialectType dialectType, FileExportProgressManager fileExportProgressManager) {
        try (Statement stat = SQLUtilities.createStatementForStreamingResults(con, dialectType);){
            ExportFileWriter.writeFile(new ResultSetExportData(stat, sqlToWriteToFile, dialectType), prefs, fileExportProgressManager.getOrCreateProgressCallback());
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("ExportToFileHandler.wrote.file", file.getPath()));
        }
        catch (Throwable e) {
            s_log.error(e);
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToFileHandler.error.writing.file", file.getPath(), e));
            this._abortExecution = this._session.getProperties().getAbortOnError();
        }
        finally {
            fileExportProgressManager.hideProgressMonitor();
        }
    }
}

