/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.sqltofile;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportControllerProxy;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSqlNamed;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.Exporter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileEndings;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportProgressManager;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelSheet;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelWorkbook;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelWorkbookList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MultipleSqlResultExportDestinationInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class ExportToMultiSheetMsExcelHandler {
    private static final ILogger s_log = LoggerController.createLogger(ExportToMultiSheetMsExcelHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportToMultiSheetMsExcelHandler.class);
    public static final String MS_EXCEL_WORKBOOK_PREFIX = "@msExcelWorkbook";
    public static final String SHEET_PREFIX = "@sheet";
    private final ISession _session;
    private final ISQLPanelAPI _sqlPaneAPI;
    private boolean _abortExecution = false;
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();

    public ExportToMultiSheetMsExcelHandler(ISession session, ISQLPanelAPI sqlPaneAPI) {
        this._session = session;
        this._sqlPaneAPI = sqlPaneAPI;
    }

    public static boolean containsMyMarkers(String initialSql) {
        return StringUtils.containsIgnoreCase((CharSequence)initialSql, (CharSequence)MS_EXCEL_WORKBOOK_PREFIX) || StringUtils.containsIgnoreCase((CharSequence)initialSql, (CharSequence)SHEET_PREFIX);
    }

    public static boolean willBeHandledByMe(QueryHolder sql) {
        if (null == sql) {
            return false;
        }
        return ExportToMultiSheetMsExcelHandler.isWorkbookPrefixed(sql) || ExportToMultiSheetMsExcelHandler.isSheetPrefixed(sql);
    }

    private static boolean isSheetPrefixed(QueryHolder sql) {
        return StringUtils.startsWithIgnoreCase((CharSequence)sql.getQuery().trim(), (CharSequence)SHEET_PREFIX);
    }

    private static boolean isWorkbookPrefixed(QueryHolder sql) {
        return StringUtils.startsWithIgnoreCase((CharSequence)sql.getQuery().trim(), (CharSequence)MS_EXCEL_WORKBOOK_PREFIX);
    }

    public String exportToMsExcel(String initialSql) {
        MsExcelWorkbook workbook;
        IQueryTokenizer queryTokenizer = this._session.getQueryTokenizer();
        queryTokenizer.setScriptToTokenize(initialSql);
        StringBuilder sqlsNotToWriteToFile = new StringBuilder();
        MsExcelWorkbookList workbooks = new MsExcelWorkbookList();
        while (queryTokenizer.hasQuery()) {
            QueryHolder query = queryTokenizer.nextQuery();
            if (!ExportToMultiSheetMsExcelHandler.willBeHandledByMe(query)) {
                sqlsNotToWriteToFile.append(query.getQuery());
                if (1 == queryTokenizer.getSQLStatementSeparator().length()) {
                    sqlsNotToWriteToFile.append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                    continue;
                }
                sqlsNotToWriteToFile.append(" ").append(queryTokenizer.getSQLStatementSeparator()).append("\n");
                continue;
            }
            String sqlWithPrefix = query.getQuery().trim();
            int contentBeginMarkerPos = sqlWithPrefix.indexOf(39);
            if (-1 == contentBeginMarkerPos) {
                if (ExportToMultiSheetMsExcelHandler.isWorkbookPrefixed(query)) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noWorkbookFileBeginMarker"));
                    continue;
                }
                if (ExportToMultiSheetMsExcelHandler.isSheetPrefixed(query)) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noSheetNameBeginMarker"));
                    continue;
                }
                throw new IllegalStateException("Should not get here as method willBeHandledByMe() returned true. Concerned SQL: " + query.getQuery());
            }
            int contentEndMarkerPos = sqlWithPrefix.indexOf(39, contentBeginMarkerPos + 1);
            if (-1 == contentEndMarkerPos) {
                if (ExportToMultiSheetMsExcelHandler.isWorkbookPrefixed(query)) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noWorkbookFileEndMarker"));
                    continue;
                }
                if (ExportToMultiSheetMsExcelHandler.isSheetPrefixed(query)) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noSheetNameEndMarker"));
                    continue;
                }
                throw new IllegalStateException("Should not get here as method willBeHandledByMe() returned true. Concerned SQL: " + query.getQuery());
            }
            if (ExportToMultiSheetMsExcelHandler.isWorkbookPrefixed(query)) {
                String workbook2 = sqlWithPrefix.substring(contentBeginMarkerPos + 1, contentEndMarkerPos).trim();
                if (FileEndings.XLS.fileEndsWith(workbook2) || FileEndings.XLSX.fileEndsWith(workbook2)) {
                    workbooks.addCurrentWorkbook(workbook2);
                } else {
                    workbooks.addCurrentWorkbook(workbook2 + "." + FileEndings.XLSX.get());
                }
                if (sqlWithPrefix.length() <= contentEndMarkerPos) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.missingSheetNameForWorkbook"));
                    continue;
                }
                String afterWorkbookSql = sqlWithPrefix.substring(contentEndMarkerPos + 1).trim();
                if (!ExportToMultiSheetMsExcelHandler.isSheetPrefixed(new QueryHolder(afterWorkbookSql))) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.missingSheetNameForWorkbook"));
                    continue;
                }
                int sheetBeginMarkerPos = afterWorkbookSql.indexOf(39);
                if (-1 == sheetBeginMarkerPos) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noSheetNameBeginMarker"));
                    continue;
                }
                int sheetEndMarkerPos = afterWorkbookSql.indexOf(39, sheetBeginMarkerPos + 1);
                if (-1 == sheetEndMarkerPos) {
                    Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.noSheetNameEndMarker"));
                    continue;
                }
                String sheetName = afterWorkbookSql.substring(sheetBeginMarkerPos + 1, sheetEndMarkerPos).trim();
                String sheetSql = afterWorkbookSql.substring(sheetEndMarkerPos + 1).trim();
                workbooks.addSheetToCurrentWorkbook(sheetName, sheetSql);
            } else if (ExportToMultiSheetMsExcelHandler.isSheetPrefixed(query)) {
                String sheetName = sqlWithPrefix.substring(contentBeginMarkerPos + 1, contentEndMarkerPos).trim();
                String sheetSql = sqlWithPrefix.substring(contentEndMarkerPos + 1).trim();
                workbooks.addSheetToCurrentWorkbook(sheetName, sheetSql);
            }
            if (workbooks.hasExportReadyWorkbook()) {
                this.callExportWorkbook(workbooks.checkoutExportReadyWorkbook());
            }
            if (!this._abortExecution) continue;
            this._abortExecution = false;
            break;
        }
        if (null != (workbook = workbooks.checkoutCurrentWorkbook())) {
            this.callExportWorkbook(workbook);
        }
        if (0 == sqlsNotToWriteToFile.length()) {
            return null;
        }
        return sqlsNotToWriteToFile.toString();
    }

    private void callExportWorkbook(MsExcelWorkbook workbook) {
        String sqlsJoined = 1 == this._session.getProperties().getSQLStatementSeparator().length() ? String.join((CharSequence)(this._session.getProperties().getSQLStatementSeparator() + "\n"), workbook.getSqlList()) : String.join((CharSequence)(" " + this._session.getProperties().getSQLStatementSeparator() + "\n"), workbook.getSqlList());
        FileExportProgressManager fileExportProgressManager = new FileExportProgressManager(this._session, sqlsJoined, () -> workbook.getWorkbookFile());
        fileExportProgressManager.getOrCreateProgressCallback(() -> this.onModalProgressDialogIsDisplaying(fileExportProgressManager, workbook));
    }

    private void onModalProgressDialogIsDisplaying(FileExportProgressManager fileExportProgressManager, MsExcelWorkbook workbook) {
        this._executorService.submit(() -> this.doWriteFile(fileExportProgressManager, workbook));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteFile(FileExportProgressManager fileExportProgressManager, MsExcelWorkbook workbook) {
        try {
            ExportControllerProxy proxy = new ExportControllerProxy(this._sqlPaneAPI.getOwningFrame(), workbook, (wb, prog) -> this.onCreateExportData(wb, prog));
            Exporter exporter = new Exporter(() -> fileExportProgressManager.getOrCreateProgressCallback(), proxy);
            exporter.export();
            fileExportProgressManager.hideProgressMonitor();
        }
        catch (Exception e) {
            s_log.error(e);
            String msg = s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.error.writing.msexcel.workbook", workbook.getWorkbookFileName(), e);
            Main.getApplication().getMessageHandler().showErrorMessage(msg);
            this._abortExecution = this._session.getProperties().getAbortOnError();
        }
        finally {
            fileExportProgressManager.hideProgressMonitor();
        }
    }

    private ExportDataInfoList onCreateExportData(MsExcelWorkbook wb, ProgressAbortCallback prog) {
        MultipleSqlResultExportDestinationInfo excelExportFile = MultipleSqlResultExportDestinationInfo.createExcelExportFile(wb.getWorkbookFile());
        ArrayList<ExportDataInfo> buf = new ArrayList<ExportDataInfo>();
        DialectType dialect = DialectFactory.getDialectType(this._session.getMetaData());
        TableExportPreferences exportPreferencesForFile = TableExportPreferencesDAO.createExportPreferencesForFile(wb.getWorkbookFile().getName());
        for (int i = 0; i < wb.getSheets().size(); ++i) {
            MsExcelSheet msExcelSheet = wb.getSheets().get(i);
            this.progress(prog, s_stringMgr.getString("ExportToMultiSheetMsExcelHandler.executingQuery.n.of.m.for.sheet.named", i + 1, wb.getSheets().size(), msExcelSheet.getSheetName()));
            ExportSqlNamed exportSqlNamed = new ExportSqlNamed(msExcelSheet.getSheetSql(), msExcelSheet.getSheetName());
            ResultSetExportData resultSetExportData = this.createResultSetExportData(exportSqlNamed.getSql(), dialect, exportPreferencesForFile);
            buf.add(new ExportDataInfo(resultSetExportData, exportSqlNamed.getExportNameFileNormalized()));
            if (!this._abortExecution) continue;
            this._abortExecution = false;
            break;
        }
        return new ExportDataInfoList(buf, excelExportFile);
    }

    public void progress(ProgressAbortCallback progressController, String task) {
        progressController.currentlyLoading(task);
    }

    private ResultSetExportData createResultSetExportData(String sql, DialectType dialect, TableExportPreferences prefs) {
        try {
            Statement stat = SQLUtilities.createStatementForStreamingResults(this._session.getSQLConnection().getConnection(), dialect);
            if (prefs.isLimitRowsChecked() && !StringUtilities.isEmpty(prefs.getRowsLimit())) {
                stat.setMaxRows(Integer.parseInt(prefs.getRowsLimit()));
            }
            return new ResultSetExportData(stat, sql, dialect);
        }
        catch (Exception e) {
            s_log.error("An error was encountered while attempting to build the data set for export. See logs for details.", e);
            throw Utilities.wrapRuntime(new ExportDataException("An error was encountered while attempting to build the data set for export. See logs for details.", e));
        }
    }
}

