/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.Frame;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert.InsertGenerator;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.StringScriptBuilder;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ProgressAbortDialog;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CreateDataScriptCommand {
    private static final ILogger s_log = LoggerController.createLogger(CreateDataScriptCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateDataScriptCommand.class);
    private ISession _session;
    private boolean _templateScriptOnly;
    private final IObjectTreeAPI _objectTreeAPI;
    private ProgressAbortDialog _progressDialog;

    public CreateDataScriptCommand(IObjectTreeAPI objectTreeAPI, boolean templateScriptOnly) {
        this._objectTreeAPI = objectTreeAPI;
        this._templateScriptOnly = templateScriptOnly;
        this._session = this._objectTreeAPI.getSession();
    }

    public void execute() {
        Frame owningFrame = SessionUtils.getOwningFrame(FrameWorkAcessor.getSQLPanelAPI(this._session));
        this._progressDialog = new ProgressAbortDialog((Window)owningFrame, s_stringMgr.getString("CreateDataScriptCommand.generating.inserts"), () -> this.onCancel());
        this._session.getApplication().getThreadPool().addTask(() -> this.onCreateScript(this._progressDialog));
        this._progressDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreateScript(ProgressAbortDialog progressDialog) {
        StringScriptBuilder sbRows = new StringScriptBuilder();
        ISQLConnection conn = this._session.getSQLConnection();
        try (Statement stmt = conn.createStatement();){
            IDatabaseObjectInfo[] dbObjs = this._objectTreeAPI.getSelectedDatabaseObjects();
            for (int k = 0; k < dbObjs.length; ++k) {
                if (!(dbObjs[k] instanceof ITableInfo)) continue;
                if (this._progressDialog.isUserCanceled()) {
                    break;
                }
                ITableInfo ti = (ITableInfo)dbObjs[k];
                String sTable = ScriptUtil.getTableName(ti);
                progressDialog.currentlyLoading(s_stringMgr.getString("CreateDataScriptCommand.executing.select", ti.getSimpleName()));
                ResultSet srcResult = this.executeDataSelectSQL(stmt, ti);
                progressDialog.currentlyLoading(s_stringMgr.getString("CreateDataScriptCommand.creating.inserts", ti.getSimpleName()));
                new InsertGenerator(this._session).genInserts(srcResult, sTable, sbRows, false, this._templateScriptOnly, () -> this._progressDialog.isUserCanceled());
            }
        }
        catch (Exception e) {
            this._session.showErrorMessage(e);
            s_log.error(e);
        }
        finally {
            GUIUtils.processOnSwingEventThread(() -> this.onScriptFinished(sbRows.getStringBuilder()));
        }
    }

    private void onScriptFinished(StringBuilder sbRows) {
        try {
            if (sbRows.length() > 0) {
                FrameWorkAcessor.appendScriptToEditor(sbRows.toString(), this._objectTreeAPI);
            }
        }
        finally {
            this._progressDialog.closeProgressDialog();
        }
    }

    private ResultSet executeDataSelectSQL(Statement stmt, ITableInfo ti) throws SQLException {
        ResultSet srcResult;
        block6: {
            StringBuilder sql = this.genDataSelectSQL(ti, ScriptUtil.getTableName(ti));
            try {
                srcResult = stmt.executeQuery(sql.toString());
            }
            catch (SQLException e) {
                boolean qualifyTableNames = Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isQualifyTableNames();
                if (!qualifyTableNames) {
                    try {
                        sql = this.genDataSelectSQL(ti, ScriptUtil.getTableName(ti, true, false));
                        srcResult = stmt.executeQuery(sql.toString());
                    }
                    catch (SQLException e1) {
                        boolean useDoubleQuotes = Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isUseDoubleQuotes();
                        if (!useDoubleQuotes) {
                            sql = this.genDataSelectSQL(ti, ScriptUtil.getTableName(ti, true, false));
                            srcResult = stmt.executeQuery(sql.toString());
                            break block6;
                        }
                        throw e;
                    }
                }
                throw e;
            }
        }
        return srcResult;
    }

    private StringBuilder genDataSelectSQL(ITableInfo ti, String tableName) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ");
        sql.append(tableName);
        if (!JDBCTypeMapper.isLongType(this.getFirstColumnType(ti))) {
            sql.append(" order by ");
            sql.append(this.getFirstColumnName(ti));
            sql.append(" asc ");
        }
        return sql;
    }

    private String getFirstColumnName(ITableInfo ti) throws SQLException {
        TableColumnInfo[] infos = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        return ScriptUtil.getColumnName(infos[0]);
    }

    private int getFirstColumnType(ITableInfo ti) throws SQLException {
        TableColumnInfo[] infos = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        return infos[0].getDataType();
    }

    private void onCancel() {
        Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("CreateDataScriptCommand.user.canceled"));
    }
}

