/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.Window;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportProgressManager;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ResultSetExport;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SelectSQLInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.time.StopWatch;

public class CreateFileOfSQLCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateFileOfSQLCommand.class);
    private static ILogger s_log = LoggerController.createLogger(CreateFileOfSQLCommand.class);
    private final ISession session;
    private ResultSetExport _resultSetExport;
    private FileExportProgressManager _fileExportProgressManager;

    public CreateFileOfSQLCommand(ISession session) {
        this.session = session;
    }

    public void execute(JFrame owner) {
        List<String> sqls = this.getSelectedSelectStatements();
        this.getSession().getApplication().getThreadPool().addTask(() -> this.doCreateFileOfCurrentSQL(SelectSQLInfo.of(sqls), owner));
    }

    public void executeForSelectedTables(Window owner, List<ITableInfo> selectedTables, IObjectTreeAPI objectTreeAPI) {
        List<SelectSQLInfo> selectSQLs = ScriptUtil.createSelectSQLs(selectedTables.toArray(new IDatabaseObjectInfo[0]), objectTreeAPI);
        this.getSession().getApplication().getThreadPool().addTask(() -> this.doCreateFileOfCurrentSQL(selectSQLs, owner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateFileOfCurrentSQL(List<SelectSQLInfo> selectSQLInfos, Window owner) {
        try {
            ISQLConnection unmangedConnection = null;
            try {
                unmangedConnection = this.createUnmanagedConnection();
                Connection con = unmangedConnection != null ? unmangedConnection.getConnection() : this.getSession().getSQLConnection().getConnection();
                this._fileExportProgressManager = new FileExportProgressManager(this.getSession(), SelectSQLInfo.toJoinedSQLs(this.getSession(), selectSQLInfos), () -> this._resultSetExport.getTargetFile());
                DialectType dialectType = DialectFactory.getDialectType(this.getSession().getMetaData());
                this._resultSetExport = new ResultSetExport(con, selectSQLInfos, dialectType, this._fileExportProgressManager, owner);
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                this._resultSetExport.export();
                stopWatch.stop();
                if (this._fileExportProgressManager.isAborted()) {
                    return;
                }
                if (this._resultSetExport.getWrittenRows() >= 0L) {
                    ExportUtil.writeExportMessage(stopWatch, this._resultSetExport.getWrittenRows(), this._resultSetExport.getTargetFile());
                }
            }
            finally {
                SQLUtilities.closeConnection(unmangedConnection);
            }
        }
        catch (Exception e) {
            s_log.error(e);
            if (e.getCause() != null) {
                this.getSession().showErrorMessage(e.getCause());
            }
            this.getSession().showErrorMessage(e.toString());
        }
        finally {
            SwingUtilities.invokeLater(() -> {
                if (null != this._fileExportProgressManager) {
                    this._fileExportProgressManager.hideProgressMonitor();
                }
            });
        }
    }

    private ISQLConnection createUnmanagedConnection() throws SQLException {
        if (DialectFactory.isUnityJDBC(this.getSession().getMetaData())) {
            return null;
        }
        SQLConnection unmanagedConnection = this.getSession().createUnmanagedConnection();
        if (unmanagedConnection == null) {
            int option = JOptionPane.showConfirmDialog(null, "Unable to open a new connection. The current connection will be used instead.", "Unable to open a new Connection", 2);
            if (option == 2) {
                return null;
            }
        } else {
            unmanagedConnection.setAutoCommit(false);
        }
        return unmanagedConnection;
    }

    public ISession getSession() {
        return this.session;
    }

    private List<String> getSelectedSelectStatements() {
        ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(this.getSession());
        String script = api.getSQLScriptToBeExecuted();
        IQueryTokenizer qt = this.getSession().getQueryTokenizer();
        qt.setScriptToTokenize(script);
        if (!qt.hasQuery()) {
            this.getSession().showErrorMessage(s_stringMgr.getString("AbstractDataScriptCommand.noQuery"));
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        while (qt.hasQuery()) {
            ret.add(qt.nextQuery().getQuery());
        }
        return ret;
    }
}

