/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.InsertScriptFinishedCallBack;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert.InsertGenerator;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.FileScriptBuilder;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.ScriptBuilder;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ProgressAbortDialog;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.TableNameFindService;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class CreateInsertScriptOfCurrentSQLCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateInsertScriptOfCurrentSQLCommand.class);
    private ISession _session;
    private ProgressAbortDialog _progressDialog;

    public CreateInsertScriptOfCurrentSQLCommand(ISession session) {
        this._session = session;
    }

    public void generateInserts(ScriptBuilder sbRows, InsertScriptFinishedCallBack insertScriptFinishedCallBack) {
        String script = FrameWorkAcessor.getSQLPanelAPI(this._session).getSQLScriptToBeExecuted();
        this.generateInserts(script, sbRows, insertScriptFinishedCallBack);
    }

    public void generateInserts(String script, ScriptBuilder scriptBuilder, InsertScriptFinishedCallBack insertScriptFinishedCallBack) {
        String fileName = null;
        if (scriptBuilder instanceof FileScriptBuilder) {
            fileName = ((FileScriptBuilder)scriptBuilder).getFileName();
        }
        Frame owningFrame = SessionUtils.getOwningFrame(FrameWorkAcessor.getSQLPanelAPI(this._session));
        this._progressDialog = new ProgressAbortDialog(owningFrame, s_stringMgr.getString("CreateInsertScriptOfCurrentSQLCommand.generating.inserts"), fileName, script, 0, () -> this.onCancel(), null);
        Main.getApplication().getThreadPool().addTask(() -> this.doGenerateInserts(script, scriptBuilder, insertScriptFinishedCallBack, this._progressDialog));
        this._progressDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGenerateInserts(String script, ScriptBuilder sbRows, InsertScriptFinishedCallBack insertScriptFinishedCallBack, ProgressAbortDialog progressDialog) {
        try {
            IQueryTokenizer qt = this._session.getQueryTokenizer();
            qt.setScriptToTokenize(script);
            if (!qt.hasQuery()) {
                this._session.showErrorMessage(s_stringMgr.getString("CreateInsertScriptOfCurrentSQLCommand.noQuery"));
                return;
            }
            ISQLConnection conn = this._session.getSQLConnection();
            while (qt.hasQuery()) {
                Statement stmt = conn.createStatement();
                try {
                    String sql = qt.nextQuery().getQuery();
                    progressDialog.setSql(sql);
                    progressDialog.currentlyLoading(StringUtils.replace((String)sql, (String)"\n", (String)" "));
                    ResultSet srcResult = stmt.executeQuery(sql);
                    String tableName = TableNameFindService.findTableNameBySqlOrResultMetaData(sql, srcResult, this._session);
                    new InsertGenerator(this._session).genInserts(srcResult, tableName, sbRows, false, false, () -> this._progressDialog.isUserCanceled());
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
        }
        catch (Exception e) {
            this._session.showErrorMessage(e);
        }
        finally {
            SwingUtilities.invokeLater(() -> this.onScriptFinished(insertScriptFinishedCallBack));
        }
    }

    private void onCancel() {
        Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("CreateInsertScriptOfCurrentSQLCommand.user.canceled"));
    }

    private void onScriptFinished(InsertScriptFinishedCallBack insertScriptFinishedCallBack) {
        try {
            insertScriptFinishedCallBack.insertScriptFinished();
        }
        finally {
            this.closeProgress();
        }
    }

    private void closeProgress() {
        if (null != this._progressDialog) {
            this._progressDialog.closeProgressDialog();
        }
    }
}

