/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateInsertScriptOfCurrentSQLCommand;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.FileScriptBuilder;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class CreateInsertStatementsFileOfCurrentSQLAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final String PREF_LAST_FILE_FILTER = "sqlscript.CreateDataFileOfCurrentSQLAction.last.file";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateInsertStatementsFileOfCurrentSQLAction.class);
    private ISQLPanelAPI _sqlPanel;

    public CreateInsertStatementsFileOfCurrentSQLAction() {
        super(Main.getApplication(), Main.getApplication().getResources());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser fileChooser;
        File buf;
        if (this._sqlPanel == null) {
            return;
        }
        String lastFileString = Props.getString(PREF_LAST_FILE_FILTER, null);
        File lastFile = new File(System.getProperty("user.home"));
        if (!StringUtilities.isEmpty(lastFileString, true) && (buf = new File(lastFileString)).getParentFile().exists()) {
            lastFile = buf;
        }
        if (lastFile.isDirectory()) {
            fileChooser = new JFileChooser(lastFile);
        } else {
            fileChooser = new JFileChooser(lastFile.getParentFile());
            fileChooser.setSelectedFile(lastFile);
        }
        if (0 != fileChooser.showSaveDialog(this._sqlPanel.getOwningFrame())) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile.exists()) {
            String msg = s_stringMgr.getString("CreateDataFileOfCurrentSQLAction.file.exists", selectedFile.getAbsolutePath());
            if (0 != JOptionPane.showConfirmDialog(this._sqlPanel.getOwningFrame(), msg)) {
                return;
            }
        }
        Props.putString(PREF_LAST_FILE_FILTER, selectedFile.getAbsolutePath());
        FileScriptBuilder sbRows = new FileScriptBuilder(selectedFile);
        new CreateInsertScriptOfCurrentSQLCommand(this._sqlPanel.getSession()).generateInserts(sbRows, () -> this.onScriptFinished(sbRows));
    }

    private void onScriptFinished(FileScriptBuilder sbRows) {
        sbRows.flush();
        Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("CreateDataFileOfCurrentSQLAction.wrote.insert.statements", sbRows.getFileName()));
    }

    @Override
    public void setSQLPanel(ISQLPanelAPI sqlPanel) {
        this._sqlPanel = sqlPanel;
        this.setEnabled(null != this._sqlPanel);
    }
}

