/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CreateSelectScriptCommand {
    private static ILogger s_log = LoggerController.createLogger(CreateSelectScriptCommand.class);
    private IObjectTreeAPI _objectTreeAPI;

    public CreateSelectScriptCommand(IObjectTreeAPI objectTreeAPI) {
        this._objectTreeAPI = objectTreeAPI;
    }

    public void execute() {
        IDatabaseObjectInfo[] dbObjs = this._objectTreeAPI.getSelectedDatabaseObjects();
        this.scriptSelectsToSQLEntryArea(dbObjs);
    }

    public void scriptSelectsToSQLEntryArea(final IDatabaseObjectInfo[] dbObjs) {
        Main.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    String script = ScriptUtil.createSelectScriptString(dbObjs, CreateSelectScriptCommand.this._objectTreeAPI);
                    if (null != script) {
                        GUIUtils.processOnSwingEventThread(() -> FrameWorkAcessor.appendScriptToEditor(script, CreateSelectScriptCommand.this._objectTreeAPI));
                    }
                }
                catch (Exception e) {
                    Main.getApplication().getMessageHandler().showErrorMessage(e);
                    s_log.error(e);
                }
            }
        });
    }
}

