/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.Frame;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.DefaultSQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateTableOfCurrentSQLCtrl;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert.InsertGenerator;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.StringScriptBuilder;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ProgressAbortDialog;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CreateTableOfCurrentSQLCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateTableOfCurrentSQLCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(CreateTableOfCurrentSQLCommand.class);
    private ISession _session;
    private ProgressAbortDialog _progressDialog;

    public CreateTableOfCurrentSQLCommand(ISession session) {
        this._session = session;
    }

    public void execute() {
        Frame owningFrame = SessionUtils.getOwningFrame(FrameWorkAcessor.getSQLPanelAPI(this._session));
        CreateTableOfCurrentSQLCtrl ctrl = new CreateTableOfCurrentSQLCtrl(owningFrame);
        if (!ctrl.isOK()) {
            return;
        }
        String sTable = ctrl.getTableName();
        boolean scriptOnly = ctrl.isScriptOnly();
        boolean dropTable = ctrl.isDropTable();
        ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(this._session);
        String script = api.getSQLScriptToBeExecuted();
        this._progressDialog = new ProgressAbortDialog((Window)owningFrame, s_stringMgr.getString("CreateTableOfCurrentSQLCommand.generating.insert.table.script", sTable), () -> this.onCancel());
        this._session.getApplication().getThreadPool().addTask(() -> this.doCreateTableOfCurrentSQL(script, sTable, scriptOnly, dropTable, this._progressDialog));
        this._progressDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateTableOfCurrentSQL(String script, String sTable, boolean scriptOnly, boolean dropTable, ProgressAbortDialog progressDialog) {
        StringBuilder sbScript = new StringBuilder();
        try {
            ResultSet srcResult;
            String sql;
            String statSep;
            StringBuilder sbDrop;
            StringScriptBuilder ssbInsert;
            StringBuilder sbCreate;
            Statement stmt;
            block15: {
                IQueryTokenizer qt = this._session.getQueryTokenizer();
                qt.setScriptToTokenize(script);
                if (!qt.hasQuery()) {
                    this._session.showErrorMessage(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.noQuery"));
                    return;
                }
                ISQLConnection conn = this._session.getSQLConnection();
                stmt = null;
                try {
                    sbCreate = new StringBuilder();
                    ssbInsert = new StringScriptBuilder();
                    sbDrop = new StringBuilder();
                    statSep = ScriptUtil.getStatementSeparator(this._session);
                    stmt = conn.createStatement();
                    stmt.setMaxRows(1);
                    progressDialog.currentlyLoading(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.executing.select.for.meta.data"));
                    sql = qt.nextQuery().getQuery();
                    progressDialog.setSql(sql);
                    srcResult = stmt.executeQuery(sql);
                    if (!this._progressDialog.isUserCanceled()) break block15;
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeStatement(stmt);
                    throw throwable;
                }
                SQLUtilities.closeStatement(stmt);
                return;
            }
            progressDialog.currentlyLoading(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.generating.script"));
            this.genCreate(srcResult, sTable, sbCreate);
            new InsertGenerator(this._session).genInserts(srcResult, sTable, ssbInsert, true, false, () -> this._progressDialog.isUserCanceled());
            StringBuilder sbInsert = ssbInsert.getStringBuilderClone();
            sbInsert.append('\n').append(sql);
            sbDrop.append("DROP TABLE " + sTable);
            if (dropTable && this._session.getSchemaInfo().isTable(sTable)) {
                sbScript.append((CharSequence)sbDrop).append(statSep);
            }
            sbScript.append((CharSequence)sbCreate).append(statSep);
            sbScript.append((CharSequence)sbInsert).append(statSep);
            SQLUtilities.closeStatement(stmt);
            if (!scriptOnly) {
                try {
                    SQLExecuterTask executer = new SQLExecuterTask(this._session, sbScript.toString(), new DefaultSQLExecuterHandler(this._session));
                    executer.run();
                    this._session.showMessage(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.successCreate", sTable));
                }
                catch (Exception e) {
                    this._session.showErrorMessage(e);
                    s_log.error(e);
                }
            }
        }
        catch (Exception e) {
            this._session.showErrorMessage(e);
            s_log.error(e);
        }
        finally {
            SwingUtilities.invokeLater(() -> this.onScriptFinished(scriptOnly, sbScript));
        }
    }

    private void onScriptFinished(boolean scriptOnly, StringBuilder sbScript) {
        try {
            if (scriptOnly && 0 < sbScript.toString().trim().length()) {
                FrameWorkAcessor.getSQLPanelAPI(this._session).appendSQLScript(sbScript.toString(), true);
                if (!(this._session.getSelectedMainTab() instanceof BaseSQLTab)) {
                    this._session.selectMainTab(1);
                }
            }
        }
        finally {
            this._progressDialog.closeProgressDialog();
        }
    }

    private void genCreate(ResultSet srcResult, String sTable, StringBuilder sbCreate) {
        try {
            ResultSetMetaData metaData = srcResult.getMetaData();
            sbCreate.append("\n\nCREATE TABLE ").append(sTable).append('\n');
            sbCreate.append("(\n");
            String sColName = metaData.getColumnName(1);
            String sColType = metaData.getColumnTypeName(1);
            int colSize = metaData.getColumnDisplaySize(1);
            int decimalDigits = metaData.getScale(1);
            sbCreate.append("   ").append(ScriptUtil.getColumnDef(sColName, sColType, colSize, decimalDigits));
            for (int i = 2; i <= metaData.getColumnCount(); ++i) {
                sbCreate.append(",\n");
                sColName = metaData.getColumnName(i);
                sColType = metaData.getColumnTypeName(i);
                colSize = metaData.getColumnDisplaySize(i);
                decimalDigits = metaData.getScale(i);
                sbCreate.append("   ").append(ScriptUtil.getColumnDef(sColName, sColType, colSize, decimalDigits));
            }
            sbCreate.append("\n)");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void onCancel() {
        Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.user.canceled"));
    }
}

