/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.awt.Frame;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.CreateTableOfCurrentSQLDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class CreateTableOfCurrentSQLCtrl {
    private CreateTableOfCurrentSQLDialog _dlg;
    private boolean _isOk;
    private static final String PREFS_KEY_LAST_TABLE_NAME = "squirrel_sqlscript_tempSqlResultTable";
    private static final String PREFS_KEY_SCRIPT_ONLY = "squirrel_sqlscript_script_only";
    private static final String PREFS_KEY_DROP_TABLE = "squirrel_sqlscript_drop_table";

    public CreateTableOfCurrentSQLCtrl(Frame parent) {
        this._dlg = new CreateTableOfCurrentSQLDialog(parent);
        this._dlg.btnOK.addActionListener(e -> this.onOK());
        this._dlg.btnCancel.addActionListener(e -> this.onCancel());
        String tempSqlResultTable = Props.getString(PREFS_KEY_LAST_TABLE_NAME, "tempSqlResultTable");
        boolean dropTable = Props.getBoolean(PREFS_KEY_DROP_TABLE, false);
        boolean scriptOnly = Props.getBoolean(PREFS_KEY_SCRIPT_ONLY, true);
        this._dlg.txtTableName.setText(tempSqlResultTable);
        this._dlg.chkDropTable.setSelected(dropTable);
        this._dlg.chkScriptOnly.setSelected(scriptOnly);
        GUIUtils.initLocation(this._dlg, 360, 180);
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onCancel() {
        this.close();
    }

    private void onOK() {
        this._isOk = true;
        Props.putString(PREFS_KEY_LAST_TABLE_NAME, this._dlg.txtTableName.getText());
        Props.putBoolean(PREFS_KEY_DROP_TABLE, this._dlg.chkDropTable.isSelected());
        Props.putBoolean(PREFS_KEY_SCRIPT_ONLY, this._dlg.chkScriptOnly.isSelected());
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    public boolean isOK() {
        return this._isOk;
    }

    public String getTableName() {
        return this._dlg.txtTableName.getText();
    }

    public boolean isScriptOnly() {
        return this._dlg.chkScriptOnly.isSelected();
    }

    public boolean isDropTable() {
        return this._dlg.chkDropTable.isSelected();
    }
}

