/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.prefs.SQLScriptPreferenceBean;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.TableScriptConfigCtrl;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CreateTableScriptCommand {
    private static ILogger s_log = LoggerController.createLogger(CreateTableScriptCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateTableScriptCommand.class);
    private IObjectTreeAPI _objectTreeAPI;

    public CreateTableScriptCommand(IObjectTreeAPI objectTreeAPI) {
        this._objectTreeAPI = objectTreeAPI;
    }

    public void execute() {
        IDatabaseObjectInfo[] dbObjs = this._objectTreeAPI.getSelectedDatabaseObjects();
        this.scriptTablesToSQLEntryArea(dbObjs);
    }

    public void scriptTablesToSQLEntryArea(final IDatabaseObjectInfo[] dbObjs) {
        Main.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                String script = CreateTableScriptCommand.this.createTableScriptString(dbObjs);
                if (null != script) {
                    GUIUtils.processOnSwingEventThread(() -> FrameWorkAcessor.appendScriptToEditor(script, CreateTableScriptCommand.this._objectTreeAPI));
                }
            }
        });
    }

    public String createTableScriptString(IDatabaseObjectInfo dbObj) {
        return this.createTableScriptString(new IDatabaseObjectInfo[]{dbObj});
    }

    public String createTableScriptString(IDatabaseObjectInfo[] dbObjs) {
        StringBuilder result = new StringBuilder(1000);
        ISQLDatabaseMetaData md = this._objectTreeAPI.getSession().getMetaData();
        try {
            boolean isJdbcOdbc = md.getURL().startsWith("jdbc:odbc:");
            if (isJdbcOdbc) {
                String msg = s_stringMgr.getString("CreateTableScriptCommand.jdbcOdbcMessage");
                this._objectTreeAPI.getSession().showErrorMessage(msg);
                s_log.error(msg);
            }
            final TableScriptConfigCtrl tscc = new TableScriptConfigCtrl(Main.getApplication().getMainFrame());
            if (1 < dbObjs.length) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        tscc.doModal();
                    }
                };
                GUIUtils.processOnSwingEventThread(task, true);
                if (!tscc.isOk()) {
                    return null;
                }
            }
            SQLScriptPreferenceBean prefs = Main.getApplication().getSQLScriptPreferencesManager().getPreferences();
            CreateScriptPreferences csprefs = new CreateScriptPreferences();
            csprefs.setConstraintsAtEnd(tscc.isConstAndIndAtEnd());
            csprefs.setIncludeExternalReferences(tscc.includeConstToTablesNotInScript());
            csprefs.setDeleteAction(prefs.getDeleteAction());
            csprefs.setDeleteRefAction(prefs.isDeleteRefAction());
            csprefs.setUpdateAction(prefs.getUpdateAction());
            csprefs.setUpdateRefAction(prefs.isUpdateRefAction());
            csprefs.setQualifyTableNames(prefs.isQualifyTableNames());
            csprefs.setUseDoubleQuotes(prefs.isUseDoubleQuotes());
            List<ITableInfo> tables = this.convertArrayToList(dbObjs);
            HibernateDialect dialect = DialectFactory.getDialect(md);
            List<String> sqls = dialect.getCreateTableSQL(tables, md, csprefs, isJdbcOdbc);
            String sep = this._objectTreeAPI.getSession().getQueryTokenizer().getSQLStatementSeparator();
            for (String sql : sqls) {
                result.append(sql);
                result.append("\n");
                result.append(sep);
                result.append("\n");
            }
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
        return result.toString();
    }

    private List<ITableInfo> convertArrayToList(IDatabaseObjectInfo[] dbObjs) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (IDatabaseObjectInfo dbObj : dbObjs) {
            if (!(dbObj instanceof ITableInfo)) continue;
            ITableInfo ti = (ITableInfo)dbObj;
            result.add(ti);
        }
        return result;
    }
}

