/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DropTableScriptCommand
implements ICommand {
    private static ILogger s_log = LoggerController.createLogger(DropTableScriptCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropTableScriptCommand.class);
    private IObjectTreeAPI _objectTreeAPI;

    public DropTableScriptCommand(IObjectTreeAPI objectTreeAPI) {
        this._objectTreeAPI = objectTreeAPI;
    }

    @Override
    public void execute() {
        IDatabaseObjectInfo[] dbObjs = this._objectTreeAPI.getSelectedDatabaseObjects();
        this.scriptTablesToSQLEntryArea(dbObjs);
    }

    public void scriptTablesToSQLEntryArea(final IDatabaseObjectInfo[] dbObjs) {
        Main.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                String script = DropTableScriptCommand.this.dropTableScriptString(dbObjs);
                if (script != null) {
                    GUIUtils.processOnSwingEventThread(() -> FrameWorkAcessor.appendScriptToEditor(script, DropTableScriptCommand.this._objectTreeAPI));
                }
            }
        });
    }

    public String dropTableScriptString(IDatabaseObjectInfo[] dbObjs) {
        StringBuffer sbScript = new StringBuffer(1000);
        try {
            for (int k = 0; k < dbObjs.length; ++k) {
                if (!(dbObjs[k] instanceof ITableInfo)) continue;
                ITableInfo ti = (ITableInfo)dbObjs[k];
                String sTable = ScriptUtil.getTableName(ti);
                sbScript.append("DROP TABLE ");
                sbScript.append(sTable);
                sbScript.append(ScriptUtil.getStatementSeparator(this._objectTreeAPI.getSession()));
                sbScript.append("\n");
            }
        }
        catch (Exception e) {
            Main.getApplication().getMessageHandler().showErrorMessage(e);
            s_log.error(e);
        }
        return sbScript.toString();
    }
}

