/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.prefs.SQLScriptPreferenceBean;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils2;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SelectSQLInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ScriptUtil {
    private static ILogger s_log = LoggerController.createLogger(ScriptUtil.class);

    public static String createSelectScriptString(IDatabaseObjectInfo[] dbObjs, IObjectTreeAPI objectTreeAPI) {
        List<SelectSQLInfo> sqls = ScriptUtil.createSelectSQLs(dbObjs, objectTreeAPI);
        StringBuilder script = new StringBuilder();
        sqls.forEach(sql -> script.append(sql.getSelectStatement()).append(ScriptUtil.getStatementSeparator(objectTreeAPI.getSession())).append('\n'));
        return script.append("\n").toString();
    }

    public static List<SelectSQLInfo> createSelectSQLs(IDatabaseObjectInfo[] dbObjs, IObjectTreeAPI objectTreeAPI) {
        try {
            ArrayList<SelectSQLInfo> ret = new ArrayList<SelectSQLInfo>();
            ISQLConnection conn = objectTreeAPI.getSession().getSQLConnection();
            boolean isJdbcOdbc = conn.getSQLMetaData().getURL().startsWith("jdbc:odbc:");
            if (isJdbcOdbc) {
                Main.getApplication().getMessageHandler().showErrorMessage("CreateSelectScriptCommand.JDBC_ODBCBridge.warn");
            }
            for (IDatabaseObjectInfo dbObj : dbObjs) {
                if (!(dbObj instanceof ITableInfo)) continue;
                StringBuilder buf = new StringBuilder();
                ITableInfo ti = (ITableInfo)dbObj;
                buf.append("SELECT ");
                TableColumnInfo[] infos = conn.getSQLMetaData().getColumnInfo(ti);
                for (int i = 0; i < infos.length; ++i) {
                    if (0 < i) {
                        buf.append(',');
                    }
                    DialectType dialectType = DialectFactory.getDialectType(objectTreeAPI.getSession().getMetaData());
                    if (Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isUseDoubleQuotes()) {
                        buf.append(ScriptUtil.getColumnName(infos[i], Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isUseDoubleQuotes()));
                        continue;
                    }
                    buf.append(DialectUtils2.checkColumnDoubleQuotes(dialectType, infos[i].getColumnName()));
                }
                buf.append(" FROM ").append(ScriptUtil.getTableName(ti));
                ret.add(new SelectSQLInfo(ti, buf.toString()));
                buf.setLength(0);
            }
            return ret;
        }
        catch (Exception e) {
            Main.getApplication().getMessageHandler().showErrorMessage(e);
            throw Utilities.wrapRuntime(e);
        }
    }

    public static String getColumnDef(String sColumnName, String sType, int columnSize, int decimalDigits) {
        sColumnName = ScriptUtil.makeColumnNameUnique(sColumnName);
        return SQLUtilities.createColumnDefinitionString(sColumnName, sType, columnSize, decimalDigits);
    }

    public static String makeColumnNameUnique(String sColumnName) {
        Hashtable<String, String> uniqueColNamesRef = new Hashtable<String, String>();
        return ScriptUtil.makeColumnNameUniqueIntern(uniqueColNamesRef, sColumnName, 0);
    }

    private static String makeColumnNameUniqueIntern(Hashtable<String, String> uniqueColNamesRef, String sColumnName, int postFixSeed) {
        Object upperCaseColumnName = sColumnName.toUpperCase();
        Object sRet = sColumnName;
        if (0 < postFixSeed) {
            sRet = (String)sRet + "_" + postFixSeed;
            upperCaseColumnName = (String)upperCaseColumnName + "_" + postFixSeed;
        }
        if (null == uniqueColNamesRef.get(upperCaseColumnName)) {
            uniqueColNamesRef.put((String)upperCaseColumnName, (String)upperCaseColumnName);
            return sRet;
        }
        return ScriptUtil.makeColumnNameUniqueIntern(uniqueColNamesRef, sColumnName, ++postFixSeed);
    }

    public static String getStatementSeparator(ISession session) {
        Object statementSeparator = session.getQueryTokenizer().getSQLStatementSeparator();
        if (1 < ((String)statementSeparator).length()) {
            statementSeparator = "\n" + (String)statementSeparator + "\n";
        }
        return statementSeparator;
    }

    public static String getTableName(ITableInfo ti) {
        SQLScriptPreferenceBean prefs = Main.getApplication().getSQLScriptPreferencesManager().getPreferences();
        return ScriptUtil.getTableName(ti, prefs.isQualifyTableNames(), prefs.isUseDoubleQuotes());
    }

    public static String getTableName(ITableInfo ti, boolean qualifyTableNames, boolean useDoubleQuotes) {
        return DialectUtils.formatQualified(ti.getSimpleName(), ti.getSchemaName(), qualifyTableNames, useDoubleQuotes);
    }

    public static String getColumnName(TableColumnInfo info) {
        return ScriptUtil.getColumnName(info, Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isUseDoubleQuotes());
    }

    public static String getColumnName(TableColumnInfo info, boolean useDoubleQuotes) {
        return ScriptUtil.getColumnName(info.getColumnName(), useDoubleQuotes);
    }

    public static String getColumnName(String columnName) {
        return ScriptUtil.getColumnName(columnName, Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isUseDoubleQuotes());
    }

    public static String getColumnName(String columnName, boolean useDoubleQuotes) {
        String unquotedColumnName = StringUtilities.stripDoubleQuotes(columnName);
        if (useDoubleQuotes) {
            return "\"" + unquotedColumnName + "\"";
        }
        return unquotedColumnName;
    }

    public static boolean isQualifyTableRequired() {
        return Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isQualifyTableNames();
    }
}

