/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.ScriptUtil;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert.InsertAbortCallBack;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.insert.InsertScriptColumnInfo;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.ScriptBuilder;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.util.TemporalUtils;

public class InsertGenerator {
    private ISession _session;

    public InsertGenerator(ISession session) {
        this._session = session;
    }

    public void genInserts(ResultSet srcResult, String sTable, ScriptBuilder sbRows, boolean headerOnly, boolean templateScriptOnly, InsertAbortCallBack insertAbortCallBack) throws SQLException {
        ResultSetMetaData metaData = srcResult.getMetaData();
        HibernateDialect dialect = DialectFactory.getDialect(this._session.getMetaData());
        int iColumnCount = metaData.getColumnCount();
        InsertScriptColumnInfo[] colInfo = new InsertScriptColumnInfo[iColumnCount];
        for (int i = 1; i <= iColumnCount; ++i) {
            colInfo[i - 1] = new InsertScriptColumnInfo(metaData.getColumnName(i), metaData.getColumnType(i));
        }
        boolean fromResultSet = !templateScriptOnly && !headerOnly;
        sbRows.append("\n\n");
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        while ((srcResult.next() || templateScriptOnly || headerOnly) && !insertAbortCallBack.isAborted()) {
            sbRows.append("INSERT INTO ");
            sbRows.append(sTable);
            StringBuilder sbColumns = new StringBuilder();
            sbColumns.append(" (");
            StringBuilder sbValues = new StringBuilder();
            sbValues.append(" VALUES (");
            for (int i = 0; i < iColumnCount; ++i) {
                int iIndexPoint = colInfo[i].columnName.lastIndexOf(46);
                sbColumns.append(ScriptUtil.getColumnName(ScriptUtil.makeColumnNameUnique(colInfo[i].columnName.substring(iIndexPoint + 1))));
                if (-6 == colInfo[i].sqlType || -5 == colInfo[i].sqlType || 5 == colInfo[i].sqlType || 4 == colInfo[i].sqlType || 6 == colInfo[i].sqlType || 7 == colInfo[i].sqlType || 8 == colInfo[i].sqlType || 2 == colInfo[i].sqlType || 3 == colInfo[i].sqlType) {
                    Object value = fromResultSet ? srcResult.getObject(i + 1) : "0" + this.getNullableComment(metaData, i + 1);
                    sbValues.append(value);
                } else if (91 == colInfo[i].sqlType || 92 == colInfo[i].sqlType || 93 == colInfo[i].sqlType) {
                    Calendar calendar = Calendar.getInstance();
                    Timestamp timestamp = null;
                    if (91 == colInfo[i].sqlType) {
                        timestamp = fromResultSet ? srcResult.getDate(i + 1) : currentTime;
                    } else if (92 == colInfo[i].sqlType) {
                        timestamp = fromResultSet ? srcResult.getTime(i + 1) : currentTime;
                    } else if (93 == colInfo[i].sqlType) {
                        Timestamp timestamp2 = timestamp = fromResultSet ? srcResult.getTimestamp(i + 1) : currentTime;
                    }
                    if (timestamp == null) {
                        sbValues.append("null");
                    } else {
                        calendar.setTime(timestamp);
                        if (91 == colInfo[i].sqlType) {
                            Object esc = TemporalUtils.format(timestamp, 91, this._session);
                            if (!fromResultSet) {
                                esc = (String)esc + this.getNullableComment(metaData, i + 1);
                            }
                            sbValues.append((String)esc);
                        } else if (92 == colInfo[i].sqlType) {
                            Object esc = TemporalUtils.format(timestamp, 92, this._session);
                            if (!fromResultSet) {
                                esc = (String)esc + this.getNullableComment(metaData, i + 1);
                            }
                            sbValues.append((String)esc);
                        } else if (93 == colInfo[i].sqlType) {
                            Object esc = TemporalUtils.format(timestamp, 93, this._session);
                            if (!fromResultSet) {
                                esc = (String)esc + this.getNullableComment(metaData, i + 1);
                            }
                            sbValues.append((String)esc);
                        }
                    }
                } else if (-7 == colInfo[i].sqlType || 16 == colInfo[i].sqlType) {
                    boolean booleanValue;
                    boolean bl = booleanValue = fromResultSet ? srcResult.getBoolean(i + 1) : false;
                    if (fromResultSet && srcResult.wasNull()) {
                        sbValues.append("null");
                    } else {
                        boolean dbSupportsTrueFalse;
                        boolean bl2 = dbSupportsTrueFalse = DialectFactory.isPostgreSQL(this._session.getMetaData()) || DialectFactory.isDerby(this._session.getMetaData());
                        if (booleanValue) {
                            if (dbSupportsTrueFalse) {
                                sbValues.append("true");
                            } else {
                                sbValues.append(1);
                            }
                        } else if (dbSupportsTrueFalse) {
                            sbValues.append("false");
                        } else {
                            sbValues.append(0);
                        }
                    }
                    if (!fromResultSet) {
                        sbValues.append(this.getNullableComment(metaData, i + 1));
                    }
                } else if (2004 == colInfo[i].sqlType || -2 == colInfo[i].sqlType) {
                    if (fromResultSet) {
                        if (srcResult.wasNull()) {
                            sbValues.append("null");
                        } else {
                            byte[] binaryData = null;
                            if (2004 == colInfo[i].sqlType) {
                                Blob blobResult = srcResult.getBlob(i + 1);
                                binaryData = blobResult.getBytes(1L, (int)blobResult.length());
                            } else {
                                binaryData = srcResult.getBytes(i + 1);
                            }
                            sbValues.append(dialect.getBinaryLiteralString(binaryData));
                        }
                    } else {
                        sbValues.append("'CAFEBABE'").append(this.getNullableComment(metaData, i + 1));
                    }
                } else {
                    String sResult;
                    String string = sResult = fromResultSet ? srcResult.getString(i + 1) : "s";
                    if (sResult == null) {
                        sbValues.append("null");
                    } else {
                        int iIndex = sResult.indexOf("'");
                        if (iIndex != -1) {
                            int iPrev = 0;
                            StringBuffer sb = new StringBuffer();
                            sb.append(sResult.substring(iPrev, iIndex));
                            sb.append('\'');
                            iPrev = iIndex;
                            iIndex = sResult.indexOf("'", iPrev + 1);
                            while (iIndex != -1) {
                                sb.append(sResult.substring(iPrev, iIndex));
                                sb.append('\'');
                                iPrev = iIndex;
                                iIndex = sResult.indexOf("'", iPrev + 1);
                            }
                            sb.append(sResult.substring(iPrev));
                            sResult = sb.toString();
                        }
                        if (Main.getApplication().getSQLScriptPreferencesManager().getPreferences().isEscapeNewLine()) {
                            sResult = InsertGenerator.escapeNewlines(sResult);
                        }
                        sbValues.append("'");
                        sbValues.append(sResult);
                        sbValues.append("'");
                        if (!fromResultSet) {
                            sbValues.append(this.getNullableComment(metaData, i + 1));
                        }
                    }
                }
                sbValues.append(",");
                sbColumns.append(",");
            }
            sbValues.setLength(sbValues.length() - 1);
            sbColumns.setLength(sbColumns.length() - 1);
            sbColumns.append(")");
            sbValues.append(")").append(this.getStatementSeparator(this._session)).append("\n");
            sbRows.append(sbColumns);
            if (!headerOnly) {
                sbRows.append(sbValues);
            }
            if (!templateScriptOnly && !headerOnly) continue;
            break;
        }
        srcResult.close();
    }

    private static String escapeNewlines(String sResult) {
        String escape = Main.getApplication().getSQLScriptPreferencesManager().getPreferences().getEscapeNewLineString();
        return sResult.replaceAll("\n", escape);
    }

    private String getNullableComment(ResultSetMetaData metaData, int colIndex) throws SQLException {
        if (0 == metaData.isNullable(colIndex)) {
            return " /*not nullable*/";
        }
        return "";
    }

    private String getStatementSeparator(ISession session) {
        Object statementSeparator = session.getQueryTokenizer().getSQLStatementSeparator();
        if (1 < ((String)statementSeparator).length()) {
            statementSeparator = "\n" + (String)statementSeparator + "\n";
        }
        return statementSeparator;
    }
}

