/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.table_script.scriptbuilder.ScriptBuilder;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class FileScriptBuilder
implements ScriptBuilder {
    private final StringBuilder _sb;
    private Path _path;
    private boolean _firstFlush = true;

    public FileScriptBuilder(File file) {
        this._path = file.toPath();
        this._sb = new StringBuilder();
    }

    @Override
    public void append(String s) {
        this._sb.append(s);
        this.checkFlush();
    }

    @Override
    public void append(StringBuilder sb) {
        this._sb.append((CharSequence)sb);
        this.checkFlush();
    }

    private void checkFlush() {
        if (100000 < this._sb.length()) {
            return;
        }
        this.flush();
    }

    public void flush() {
        try {
            if (this._firstFlush) {
                Files.deleteIfExists(this._path);
                Files.writeString(this._path, (CharSequence)this._sb, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
                this._firstFlush = false;
            } else {
                Files.writeString(this._path, (CharSequence)this._sb, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
            this._sb.setLength(0);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public String getFileName() {
        return this._path.toFile().getAbsolutePath();
    }
}

