/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action.worksheettypechoice;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ChanneledAction;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.action.SquirrelActionChannel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.action.toolbarbuttonchooser.EnabledListener;
import net.sourceforge.squirrel_sql.client.session.action.worksheettypechoice.SQLWorksheetTypeEnum;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class NewSQLWorksheetAction
extends SquirrelAction
implements ISessionAction,
ChanneledAction {
    private ISession _session;
    private SquirrelActionChannel _squirrelActionChannel = new SquirrelActionChannel();
    private EnabledListener _enabledListener;

    public NewSQLWorksheetAction(IApplication app) {
        super(app);
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        switch (SQLWorksheetTypeEnum.getSelectedType()) {
            case SQL_WORKSHEET: {
                this.getApplication().getWindowManager().createSQLInternalFrame(this._session);
                break;
            }
            case SQL_TAB: {
                SessionUtils.createSQLTab(this._session);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown selected SQLWorksheetTypeEnum " + SQLWorksheetTypeEnum.getSelectedType());
            }
        }
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
        GUIUtils.processOnSwingEventThread(() -> this.onEnabledChanged());
    }

    private void onEnabledChanged() {
        boolean enabled = null != this._session;
        super.setEnabled(enabled);
        if (null != this._enabledListener) {
            this._enabledListener.enabledChanged(enabled);
        }
    }

    @Override
    public SquirrelActionChannel getActionChannel() {
        return this._squirrelActionChannel;
    }

    public void setEnabledListener(EnabledListener enabledListener) {
        this._enabledListener = enabledListener;
    }
}

