/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.connectionpool;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.openconnection.OpenConnectionUtil;
import net.sourceforge.squirrel_sql.client.session.connectionpool.CatalogComboReader;
import net.sourceforge.squirrel_sql.client.session.connectionpool.ConnectionPropertySetter;
import net.sourceforge.squirrel_sql.client.session.connectionpool.MessageHandlerReader;
import net.sourceforge.squirrel_sql.client.session.connectionpool.SessionConnectionPoolChangeListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnectionState;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class SessionConnectionPool {
    private static final ILogger s_log = LoggerController.createLogger(SessionConnectionPool.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionConnectionPool.class);
    private final SQLConnection _masterConnection;
    private final PropertyChangeListener _propertyChangeListener;
    private final SessionProperties _sessionProperties;
    private final SQLAlias _sqlAlias;
    private final String _userName;
    private final String _password;
    private final MessageHandlerReader _messageHandlerReader;
    private CatalogComboReader _catalogComboReader;
    private HashMap<ISQLConnection, Integer> _querySQLConnections_checkOutCount = new HashMap();
    private SessionConnectionPoolChangeListener _sessionConnectionPoolChangeListener;
    private volatile boolean _autoCommit;

    public SessionConnectionPool(SQLConnection masterConnection, SQLAlias sqlAlias, String userName, String password, SessionProperties sessionProperties, MessageHandlerReader messageHandlerReader, CatalogComboReader catalogComboReader) {
        this._masterConnection = masterConnection;
        try {
            this._autoCommit = TimeOutUtil.callWithTimeout(() -> this._masterConnection.getAutoCommit());
        }
        catch (Exception e) {
            s_log.error("Failed to read the connection's autoCommit flag.", e);
        }
        this._sessionProperties = sessionProperties;
        this._sqlAlias = sqlAlias;
        this._userName = userName;
        this._password = password;
        this._messageHandlerReader = messageHandlerReader;
        this._catalogComboReader = catalogComboReader;
        this._propertyChangeListener = evt -> this.onPropertyChange(evt);
        this._sessionProperties.addPropertyChangeListener(this._propertyChangeListener);
    }

    private void onPropertyChange(PropertyChangeEvent evt) {
        if (StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(evt.getPropertyName(), "queryConnectionPoolSize")) {
            if (evt.getNewValue() instanceof Integer && evt.getOldValue() instanceof Integer && (Integer)evt.getNewValue() < (Integer)evt.getOldValue()) {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("SessionConnectionPool.decreasing.existing.connections.not.close"));
            }
            this.fireChanged();
        }
    }

    public synchronized ISQLConnection getMasterSQLConnection() {
        return this._masterConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ISQLConnection checkOutUserQuerySQLConnection() {
        try {
            if (!this._autoCommit || 0 == this._sessionProperties.getQueryConnectionPoolSize()) {
                SQLConnection sQLConnection = this._masterConnection;
                return sQLConnection;
            }
            if (0 == this._querySQLConnections_checkOutCount.size()) {
                ISQLConnection buf;
                ISQLConnection iSQLConnection = buf = this.createNewQuerySQLConnection();
                return iSQLConnection;
            }
            ISQLConnection ret = this.getMinCheckoutCountQuerySQLConnections();
            int checkOutCount = this._querySQLConnections_checkOutCount.get(ret);
            if (0 == checkOutCount) {
                this._querySQLConnections_checkOutCount.put(ret, 1);
                ISQLConnection iSQLConnection = ret;
                return iSQLConnection;
            }
            if (this._querySQLConnections_checkOutCount.size() < this._sessionProperties.getQueryConnectionPoolSize()) {
                ISQLConnection buf;
                ISQLConnection iSQLConnection = buf = this.createNewQuerySQLConnection();
                return iSQLConnection;
            }
            this._querySQLConnections_checkOutCount.put(ret, ++checkOutCount);
            ISQLConnection iSQLConnection = ret;
            return iSQLConnection;
        }
        finally {
            this.fireChanged();
        }
    }

    public synchronized void returnUserQuerySQLConnection(ISQLConnection conn) {
        if (this._masterConnection != conn && this._querySQLConnections_checkOutCount.containsKey(conn)) {
            this._querySQLConnections_checkOutCount.put(conn, Math.max(this._querySQLConnections_checkOutCount.get(conn) - 1, 0));
            this.fireChanged();
        }
    }

    private ISQLConnection getMinCheckoutCountQuerySQLConnections() {
        int minCeckoutCount = Integer.MAX_VALUE;
        ISQLConnection ret = null;
        for (Map.Entry<ISQLConnection, Integer> entry : this._querySQLConnections_checkOutCount.entrySet()) {
            if (0 == entry.getValue()) {
                return entry.getKey();
            }
            if (entry.getValue() >= minCeckoutCount) continue;
            ret = entry.getKey();
            minCeckoutCount = entry.getValue();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISQLConnection createNewQuerySQLConnection() {
        try {
            if (!this._autoCommit) {
                throw new IllegalStateException("How could we get here as _autoCommit == false switches the pool off?");
            }
            SQLConnectionState sqlConnectionState = new SQLConnectionState();
            sqlConnectionState.saveState(this._masterConnection, this._sessionProperties, this._messageHandlerReader.getMessageHandler(), this._catalogComboReader.getCatalogFormComboBox());
            SQLConnection sqlConnection = OpenConnectionUtil.createSQLConnection(this._sqlAlias, this._userName, this._password, sqlConnectionState.getConnectionProperties());
            sqlConnectionState.restoreState(sqlConnection, this._messageHandlerReader.getMessageHandler());
            sqlConnection.setAutoCommit(true);
            this._querySQLConnections_checkOutCount.put(sqlConnection, 1);
            SQLConnection sQLConnection = sqlConnection;
            return sQLConnection;
        }
        catch (Throwable t) {
            String msg = s_stringMgr.getString("SessionConnectionPool.failed.to.create.pool.connection");
            Main.getApplication().getMessageHandler().showErrorMessage(msg, Utilities.getDeepestThrowable(t));
            s_log.error(msg, t);
            SQLConnection sQLConnection = this._masterConnection;
            return sQLConnection;
        }
        finally {
            this.fireChanged();
        }
    }

    public void close() {
        try {
            this._sessionProperties.removePropertyChangeListener(this._propertyChangeListener);
            TimeOutUtil.invokeWithTimeout(() -> this.getAllSQLConnections().forEach(con -> this.closeConnection((ISQLConnection)con, false)));
        }
        catch (Throwable t) {
            s_log.error("Error closing connections of connection pool", t);
        }
    }

    private void closeConnection(ISQLConnection con, boolean fireChanged) {
        if (null != this._querySQLConnections_checkOutCount.remove(con) && fireChanged) {
            try {
                this.fireChanged();
            }
            catch (Exception e) {
                s_log.error("Error firing pool changed", e);
            }
        }
        SQLUtilities.closeConnection(con);
    }

    public synchronized Set<ISQLConnection> getAllSQLConnections() {
        HashSet<ISQLConnection> ret = new HashSet<ISQLConnection>();
        ret.add(this._masterConnection);
        ret.addAll(this._querySQLConnections_checkOutCount.keySet());
        return ret;
    }

    public synchronized void setSessionAutoCommit(boolean autoCommit) {
        this._autoCommit = false;
        try {
            TimeOutUtil.invokeWithTimeout(() -> this._masterConnection.setAutoCommit(autoCommit));
            this._autoCommit = autoCommit;
        }
        catch (Exception e) {
            s_log.error("Setting autoCommit failed", e);
            try {
                this._autoCommit = Utilities.callWithTimeout(() -> this._masterConnection.getAutoCommit());
            }
            catch (Exception ex) {
                s_log.error("Error trying to read autoCommit after setting failed (former exception is of higher interest): " + e);
            }
            throw Utilities.wrapRuntime(e);
        }
        finally {
            this.fireChanged();
        }
    }

    public void setSessionCatalog(String selectedCatalog) {
        this.setPropertyInAllConnections("catalog", con -> con.setCatalog(selectedCatalog));
    }

    public void setSessionSchema(String selectedSchema) {
        this.setPropertyInAllConnections("schema", con -> con.setSchema(selectedSchema));
    }

    public void setSessionCommitOnClose(boolean commitOnClosingConnection) {
        this.setPropertyInAllConnections("commitOnClosingConnection", con -> con.setCommitOnClose(commitOnClosingConnection));
    }

    private void setPropertyInAllConnections(String propertyDesc, ConnectionPropertySetter connectionPropertySetter) {
        try {
            TimeOutUtil.invokeWithTimeout(() -> connectionPropertySetter.setProperty(this._masterConnection));
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
        this.setPropertyInAllQueryConnections(propertyDesc, connectionPropertySetter);
    }

    private void setPropertyInAllQueryConnections(String propertyDesc, ConnectionPropertySetter connectionPropertySetter) {
        HashSet<ISQLConnection> toClose = new HashSet<ISQLConnection>();
        for (ISQLConnection sqlCon : this._querySQLConnections_checkOutCount.keySet()) {
            try {
                TimeOutUtil.invokeWithTimeout(() -> connectionPropertySetter.setProperty(sqlCon));
            }
            catch (Exception e) {
                String msg = "Error setting " + propertyDesc + " for query pool connection. The connection will be closed removed from the query pool.";
                s_log.error(msg, e);
                toClose.add(sqlCon);
            }
        }
        toClose.forEach(con -> this.closeConnection((ISQLConnection)con, true));
    }

    private void execSqlOnAllQueryConnections(QueryHolder queryHolder) {
        HashSet<ISQLConnection> toClose = new HashSet<ISQLConnection>();
        for (ISQLConnection sqlCon : this._querySQLConnections_checkOutCount.keySet()) {
            try {
                TimeOutUtil.invokeWithTimeout(() -> {
                    try (Statement stat = sqlCon.createStatement();){
                        stat.execute(queryHolder.getCleanQuery());
                    }
                });
            }
            catch (Exception e) {
                s_log.error("Error executing the following SQL on pooled query connection:\n" + queryHolder.getCleanQuery(), e);
                toClose.add(sqlCon);
            }
        }
        toClose.forEach(con -> this.closeConnection((ISQLConnection)con, true));
    }

    public void setPoolChangeListener(SessionConnectionPoolChangeListener sessionConnectionPoolChangeListener) {
        this._sessionConnectionPoolChangeListener = sessionConnectionPoolChangeListener;
    }

    private void fireChanged() {
        if (null != this._sessionConnectionPoolChangeListener) {
            GUIUtils.processOnSwingEventThread(() -> this._sessionConnectionPoolChangeListener.changed());
        }
    }

    public boolean isAutoCommit() {
        return this._autoCommit;
    }

    public int getInUseQuerySqlConnectionsCount() {
        if (!this._autoCommit) {
            return 0;
        }
        return (int)this._querySQLConnections_checkOutCount.values().stream().filter(inUseCount -> inUseCount > 0).count();
    }

    public int getMaxCheckoutCount() {
        return this._querySQLConnections_checkOutCount.values().stream().max(Integer::compare).get();
    }

    public int getQueryConnectionPoolSize() {
        return this._sessionProperties.getQueryConnectionPoolSize();
    }

    public void sqlStatementExecuted(QueryHolder queryHolder) {
        if (0 == this.getQueryConnectionPoolSize()) {
            return;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)queryHolder.getCleanQuery(), (CharSequence)"SET TRANSACTION ISOLATION LEVEL")) {
            this.execSqlOnAllQueryConnections(queryHolder);
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SessionConnectionPool.isolation.level.change.statement.executed", queryHolder.getCleanQuery()));
        }
    }
}

