/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.connectionpool;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PreferencesAddressBook;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.SessionPropertiesCommand;
import net.sourceforge.squirrel_sql.client.session.connectionpool.SessionConnectionPoolStatusBarPanel;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SessionConnectionPoolStatusBarCtrl
extends JComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionConnectionPoolStatusBarCtrl.class);
    private final SessionConnectionPoolStatusBarPanel _statusBarPanel;
    private SessionAdapter _sessionReconnectListener;
    private ISession _session;

    public SessionConnectionPoolStatusBarCtrl(ISession session, JComponent parent) {
        this._session = session;
        this._statusBarPanel = new SessionConnectionPoolStatusBarPanel(parent);
        this._statusBarPanel.btnConfigureConnectionPoolSize.addActionListener(e -> this.onChangeConnectionPoolSize());
        this.initPoolListening();
        this.onPoolChanged();
    }

    private void onChangeConnectionPoolSize() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mnuFutureSessions = new JMenuItem(s_stringMgr.getString("SessionConnectionPool.pool.size.for.future.sessions"));
        mnuFutureSessions.addActionListener(e -> this.openSessionPropertiesAtSqlTab(false));
        popupMenu.add(mnuFutureSessions);
        JMenuItem mnuCurrentSession = new JMenuItem(s_stringMgr.getString("SessionConnectionPool.pool.size.for.current.session"));
        mnuCurrentSession.addActionListener(e -> this.openSessionPropertiesAtSqlTab(true));
        popupMenu.add(mnuCurrentSession);
        popupMenu.show(this._statusBarPanel.btnConfigureConnectionPoolSize, this._statusBarPanel.btnConfigureConnectionPoolSize.getWidth(), this._statusBarPanel.btnConfigureConnectionPoolSize.getHeight());
    }

    private void openSessionPropertiesAtSqlTab(boolean forCurrentSession) {
        if (forCurrentSession) {
            new SessionPropertiesCommand(this._session, 2).execute();
        } else {
            PreferencesAddressBook.QUERY_CONNECTION_POOL_PREFS.jumpTo();
        }
    }

    private void initPoolListening() {
        this._session.getConnectionPool().setPoolChangeListener(() -> this.onPoolChanged());
        this._sessionReconnectListener = new SessionAdapter(){

            @Override
            public void reconnected(SessionEvent evt) {
                evt.getSession().getConnectionPool().setPoolChangeListener(() -> SessionConnectionPoolStatusBarCtrl.this.onPoolChanged());
                SessionConnectionPoolStatusBarCtrl.this.onPoolChanged();
            }
        };
        Main.getApplication().getSessionManager().addSessionListener(this._sessionReconnectListener);
        this._session.addSimpleSessionListener(() -> Main.getApplication().getSessionManager().removeSessionListener(this._sessionReconnectListener));
    }

    private void onPoolChanged() {
        int maxQuerySqlConnectionsCount = this._session.getConnectionPool().getQueryConnectionPoolSize();
        int inUseQuerySqlConnectionsCount = this._session.getConnectionPool().getInUseQuerySqlConnectionsCount();
        boolean autoCommit = this._session.getConnectionPool().isAutoCommit();
        if (0 == maxQuerySqlConnectionsCount) {
            this._statusBarPanel.btnState.setIcon(Main.getApplication().getResources().getIcon("white_gem"));
            this._statusBarPanel.textLbl.setText(s_stringMgr.getString("SessionConnectionPool.state.message.inactive", maxQuerySqlConnectionsCount, inUseQuerySqlConnectionsCount));
        } else if (!autoCommit) {
            this._statusBarPanel.btnState.setIcon(Main.getApplication().getResources().getIcon("white_gem"));
            this._statusBarPanel.textLbl.setText(s_stringMgr.getString("SessionConnectionPool.state.message.autocommit.false", maxQuerySqlConnectionsCount, inUseQuerySqlConnectionsCount));
        } else if (inUseQuerySqlConnectionsCount == maxQuerySqlConnectionsCount) {
            if (1 < this._session.getConnectionPool().getMaxCheckoutCount()) {
                this._statusBarPanel.btnState.setIcon(Main.getApplication().getResources().getIcon("red_gem"));
                this._statusBarPanel.textLbl.setText(s_stringMgr.getString("SessionConnectionPool.state.message.over.used", maxQuerySqlConnectionsCount, inUseQuerySqlConnectionsCount));
            } else {
                this._statusBarPanel.btnState.setIcon(Main.getApplication().getResources().getIcon("yellow_gem"));
                this._statusBarPanel.textLbl.setText(s_stringMgr.getString("SessionConnectionPool.state.message.all.used", maxQuerySqlConnectionsCount, inUseQuerySqlConnectionsCount));
            }
        } else {
            this._statusBarPanel.btnState.setIcon(Main.getApplication().getResources().getIcon("green_gem"));
            this._statusBarPanel.textLbl.setText(s_stringMgr.getString("SessionConnectionPool.state.message.active", maxQuerySqlConnectionsCount, inUseQuerySqlConnectionsCount));
        }
    }

    public SessionConnectionPoolStatusBarPanel getStatusBarPanel() {
        return this._statusBarPanel;
    }
}

