/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.defaultentry;

import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import net.sourceforge.squirrel_sql.client.gui.dnd.FileEditorDropTargetListener;
import net.sourceforge.squirrel_sql.client.session.BaseSQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.PrioritizedCaretMouseListener;
import net.sourceforge.squirrel_sql.client.session.SQLTokenListener;
import net.sourceforge.squirrel_sql.client.session.defaultentry.SquirrelDefaultTextArea;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintHandler;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintListener;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DefaultSQLEntryPanel
extends BaseSQLEntryPanel {
    private static ILogger s_log = LoggerController.createLogger(DefaultSQLEntryPanel.class);
    private ISession _session;
    private SquirrelDefaultTextArea _defaultTextArea;
    private final JScrollPane _defaultTextScrollPane;
    private DropTarget dt;

    public DefaultSQLEntryPanel(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this._defaultTextArea = new SquirrelDefaultTextArea(session);
        this._defaultTextScrollPane = new JScrollPane(this._defaultTextArea);
        this.dt = new DropTarget(this._defaultTextArea, new FileEditorDropTargetListener(session));
    }

    @Override
    public JTextArea getTextComponent() {
        return this._defaultTextArea;
    }

    @Override
    public JScrollPane getTextAreaEmbeddedInScrollPane() {
        return this._defaultTextScrollPane;
    }

    @Override
    public void setTextAreaPaintListener(TextAreaPaintListener textAreaPaintListener) {
        this._defaultTextArea.setTextAreaPaintListener(textAreaPaintListener);
    }

    @Override
    public TextAreaPaintHandler getTextAreaPaintHandler() {
        return this._defaultTextArea.getTextAreaPaintHandler();
    }

    @Override
    public boolean getDoesTextComponentHaveScroller() {
        return false;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener lis) {
        this._defaultTextArea.getDocument().addUndoableEditListener(lis);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener lis) {
        this._defaultTextArea.getDocument().removeUndoableEditListener(lis);
    }

    @Override
    public boolean hasOwnUndoableManager() {
        return false;
    }

    @Override
    public String getText() {
        return this._defaultTextArea.getText();
    }

    @Override
    public String getSelectedText() {
        return this._defaultTextArea.getSelectedText();
    }

    @Override
    public void setText(String sqlScript) {
        this.setText(StringUtilities.removeCarriageReturn(sqlScript), true);
    }

    @Override
    public void setText(String sqlScript, boolean select) {
        this._defaultTextArea.setText(sqlScript);
        if (select) {
            this.setSelectionEnd(this.getText().length());
            this.setSelectionStart(0);
        }
        this._defaultTextArea.setCaretPosition(0);
    }

    @Override
    public void appendText(String sqlScript) {
        this.appendText(sqlScript, false);
    }

    @Override
    public void appendText(String sqlScript, boolean select) {
        int start = select ? this.getText().length() : 0;
        this._defaultTextArea.append(sqlScript);
        if (select) {
            this.setSelectionEnd(this.getText().length());
            this.setSelectionStart(start);
        }
    }

    @Override
    public void replaceSelection(String sqlScript) {
        this._defaultTextArea.replaceSelection(sqlScript);
    }

    @Override
    public int getCaretPosition() {
        return this._defaultTextArea.getCaretPosition();
    }

    @Override
    public void setTabSize(int tabSize) {
        this._defaultTextArea.setTabSize(tabSize);
    }

    @Override
    public void setFont(Font font) {
        this._defaultTextArea.setFont(font);
    }

    @Override
    public void addMouseListener(MouseListener lis) {
        this._defaultTextArea.addMouseListener(lis);
    }

    @Override
    public void removeMouseListener(MouseListener lis) {
        this._defaultTextArea.removeMouseListener(lis);
    }

    @Override
    public void setCaretPosition(int pos) {
        this._defaultTextArea.setCaretPosition(pos);
    }

    @Override
    public int getCaretLineNumber() {
        int caretPosition = this._defaultTextArea.getCaretPosition();
        return this.getLineOfPosition(caretPosition);
    }

    @Override
    public int getLineOfPosition(int pos) {
        try {
            return this._defaultTextArea.getLineOfOffset(pos);
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    @Override
    public int getCaretLinePosition() {
        int caretPos;
        int caretLineOffset = caretPos = this._defaultTextArea.getCaretPosition();
        try {
            caretLineOffset = this._defaultTextArea.getLineStartOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException ex) {
            s_log.error("BadLocationException in getCaretLinePosition", ex);
        }
        return caretPos - caretLineOffset;
    }

    @Override
    public int getSelectionStart() {
        return this._defaultTextArea.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int pos) {
        this._defaultTextArea.setSelectionStart(pos);
    }

    @Override
    public int getSelectionEnd() {
        return this._defaultTextArea.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int pos) {
        this._defaultTextArea.setSelectionEnd(pos);
    }

    @Override
    public boolean hasFocus() {
        return this._defaultTextArea.hasFocus();
    }

    @Override
    public void requestFocus() {
        this._defaultTextArea.requestFocus();
    }

    @Override
    public void addCaretListener(CaretListener lis) {
        this._defaultTextArea.removeCaretListener(lis);
        this._defaultTextArea.addCaretListener(lis);
    }

    @Override
    public void removeCaretListener(CaretListener lis) {
        this._defaultTextArea.removeCaretListener(lis);
    }

    @Override
    public void addSQLTokenListener(SQLTokenListener tl) {
    }

    @Override
    public void removeSQLTokenListener(SQLTokenListener tl) {
    }

    @Override
    public ISession getSession() {
        return this._session;
    }

    public void setMarkCurrentSQLActive(boolean b) {
        this._defaultTextArea.setMarkCurrentSQLActive(b);
    }

    @Override
    public void setUndoManager(UndoManager manager) {
        this._defaultTextArea.getDocument().addUndoableEditListener(manager);
    }

    @Override
    public void setPrioritizedCaretMouseListener(PrioritizedCaretMouseListener prioritizedCaretMouseListener) {
        this._defaultTextArea.setPrioritizedCaretMouseListener(prioritizedCaretMouseListener);
    }
}

