/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.defaultentry;

import java.awt.Graphics;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.PrioritizedCaretMouseListener;
import net.sourceforge.squirrel_sql.client.session.defaultentry.SquirrelDefaultCaretWithPrioritizedMouseListener;
import net.sourceforge.squirrel_sql.client.session.editorpaint.EditorPaintService;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintHandler;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class SquirrelDefaultTextArea
extends JTextArea {
    private TextAreaPaintHandler _textAreaPaintHandler;

    SquirrelDefaultTextArea(ISession session) {
        SessionProperties props = session.getProperties();
        FontInfo fi = props.getFontInfo();
        if (fi != null) {
            this.setFont(props.getFontInfo().createFont());
        }
        this._textAreaPaintHandler = new TextAreaPaintHandler(this, EditorPaintService.EMPTY, session);
        SquirrelDefaultCaretWithPrioritizedMouseListener caret = new SquirrelDefaultCaretWithPrioritizedMouseListener();
        caret.setBlinkRate(this.getCaret().getBlinkRate());
        this.getCaret().deinstall(this);
        this.setCaret(caret);
        this.putClientProperty("caretWidth", 3);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this._textAreaPaintHandler.onPaint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this._textAreaPaintHandler.onPaintComponent(g);
    }

    public void setMarkCurrentSQLActive(boolean b) {
        this._textAreaPaintHandler.getMarkCurrentSqlHandler().setActive(b);
    }

    public void setTextAreaPaintListener(TextAreaPaintListener textAreaPaintListener) {
        this._textAreaPaintHandler.setTextAreaPaintListener(textAreaPaintListener);
    }

    public TextAreaPaintHandler getTextAreaPaintHandler() {
        return this._textAreaPaintHandler;
    }

    @Override
    public void replaceSelection(String text) {
        super.replaceSelection(StringUtilities.replaceNonBreakingSpacesBySpaces(text));
    }

    public void setPrioritizedCaretMouseListener(PrioritizedCaretMouseListener prioritizedCaretMouseListener) {
        ((SquirrelDefaultCaretWithPrioritizedMouseListener)this.getCaret()).setPrioritizedCaretMouseListener(prioritizedCaretMouseListener);
    }
}

