/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.sqlbounds.BoundsOfSqlHandler;

public class MarkCurrentSqlHandler {
    private static final Rectangle NULL_RECT = new Rectangle(-1, -1, -1, -1);
    private boolean _active = true;
    private BoundsOfSqlHandler _boundsOfSqlHandler;
    private JTextComponent _textComponent;
    private Rectangle _currentRect = (Rectangle)NULL_RECT.clone();
    private Color _markColor;

    public MarkCurrentSqlHandler(JTextComponent textComponent, ISession session) {
        SquirrelPreferences squirrelPreferences = session.getApplication().getSquirrelPreferences();
        if (!squirrelPreferences.isMarkCurrentSql()) {
            this._active = false;
            return;
        }
        this._markColor = squirrelPreferences.getCurrentSqlMarkColor();
        this._textComponent = textComponent;
        this._boundsOfSqlHandler = new BoundsOfSqlHandler(this._textComponent, session);
    }

    public void paintMark(Graphics g) {
        if (!this._active) {
            return;
        }
        Color buf = g.getColor();
        int x = MarkCurrentSqlHandler.NULL_RECT.x;
        int y = MarkCurrentSqlHandler.NULL_RECT.y;
        int width = MarkCurrentSqlHandler.NULL_RECT.width;
        int height = MarkCurrentSqlHandler.NULL_RECT.height;
        try {
            if (null != this._textComponent.getSelectedText()) {
                return;
            }
            int[] bounds = this._boundsOfSqlHandler.getSqlBoundsBySeparatorRule(this._textComponent.getCaretPosition());
            if (bounds[0] + 1 >= bounds[1]) {
                return;
            }
            g.setColor(this._markColor);
            Rectangle2D beg = this._textComponent.modelToView2D(bounds[0]);
            Rectangle2D end = this._textComponent.modelToView2D(bounds[1]);
            int maxSqlX = this.getMaxSqlX(bounds, end);
            x = 0;
            y = (int)beg.getY();
            width = maxSqlX - x;
            height = (int)(end.getHeight() + end.getY() - beg.getY());
            g.drawRect(x, y, width, height);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        finally {
            g.setColor(buf);
            this.triggerRepaintIfChanged(x, y, width, height);
        }
    }

    private int getMaxSqlX(int[] bounds, Rectangle2D end) throws BadLocationException {
        String text = this._textComponent.getText();
        int maxSqlX = 0;
        for (int i = bounds[0]; i < bounds[1]; ++i) {
            if ('\n' != text.charAt(i)) continue;
            Rectangle2D rectangle = this._textComponent.modelToView2D(i);
            maxSqlX = (int)Math.max((double)maxSqlX, rectangle.getX() + rectangle.getWidth());
        }
        maxSqlX = (int)Math.max((double)maxSqlX, end.getX() + end.getWidth());
        return maxSqlX;
    }

    private void triggerRepaintIfChanged(int x, int y, int width, int height) {
        boolean repaint = false;
        if (null == this._currentRect) {
            repaint = true;
            this._currentRect = new Rectangle();
        } else if (x != this._currentRect.x || y != this._currentRect.y || width != this._currentRect.width || height != this._currentRect.height) {
            repaint = true;
        }
        if (repaint) {
            this._currentRect.x = x;
            this._currentRect.y = y;
            this._currentRect.width = width;
            this._currentRect.height = height;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarkCurrentSqlHandler.this._textComponent.repaint();
                }
            });
        }
    }

    public void setActive(boolean b) {
        this._active = false;
    }
}

