/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint;

import java.awt.Graphics;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.editorpaint.EditorPaintService;
import net.sourceforge.squirrel_sql.client.session.editorpaint.MarkCurrentSqlHandler;
import net.sourceforge.squirrel_sql.client.session.editorpaint.TextAreaPaintListener;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiCaretHandler;

public class TextAreaPaintHandler {
    private MarkCurrentSqlHandler _markCurrentSqlHandler;
    private TextAreaPaintListener _textAreaPaintListener;
    private MultiCaretHandler _multiCaretHandler;

    public TextAreaPaintHandler(JTextArea editor, EditorPaintService paintService, ISession session) {
        this._markCurrentSqlHandler = new MarkCurrentSqlHandler(editor, session);
        this._multiCaretHandler = new MultiCaretHandler(editor, paintService);
    }

    public void setTextAreaPaintListener(TextAreaPaintListener textAreaPaintListener) {
        this._textAreaPaintListener = textAreaPaintListener;
    }

    public MarkCurrentSqlHandler getMarkCurrentSqlHandler() {
        return this._markCurrentSqlHandler;
    }

    public void onPaint(Graphics g) {
        this._markCurrentSqlHandler.paintMark(g);
        if (null != this._textAreaPaintListener) {
            this._textAreaPaintListener.paint();
        }
    }

    public void onPaintComponent(Graphics g) {
        this._multiCaretHandler.onPaintComponent(g);
    }

    public MultiCaretHandler getMultiCaretHandler() {
        return this._multiCaretHandler;
    }
}

