/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret;

import java.util.ArrayList;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.DocEventExt;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiEdits;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.SingleEdit;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DocumentMultiEditor {
    private JTextArea _textArea;
    private MultiEdits _multiEdits;
    private boolean _updating = false;
    private ArrayList<DocEventExt> _executesToApplyToSecondaryEdits = new ArrayList();

    public DocumentMultiEditor(JTextArea textArea, MultiEdits multiEdits) {
        this._textArea = textArea;
        this._multiEdits = multiEdits;
    }

    public void executeInsert(DocumentEvent e) {
        try {
            String insertString = e.getDocument().getText(e.getOffset(), e.getLength());
            this._executesToApplyToSecondaryEdits.add(new DocEventExt(e, insertString));
            SwingUtilities.invokeLater(() -> this.flush());
        }
        catch (BadLocationException ex) {
            throw Utilities.wrapRuntime(ex);
        }
    }

    private void _executeInsert(DocumentEvent e, String insertString) {
        try {
            this.logDocEvt(e);
            this._updating = true;
            int ancestorCount = 0;
            for (SingleEdit singleEdit : this._multiEdits.allButInitial()) {
                singleEdit.adjustByAncestorShift(++ancestorCount * insertString.length());
                int editsInsertStart = singleEdit.getStart() + (e.getOffset() - this._multiEdits.initial().getStart());
                if (0 > editsInsertStart || editsInsertStart >= this._textArea.getText().length()) continue;
                this._textArea.getDocument().insertString(editsInsertStart, insertString, null);
            }
        }
        catch (BadLocationException ex) {
            throw Utilities.wrapRuntime(ex);
        }
        finally {
            this._updating = false;
        }
    }

    public void executeRemove(DocumentEvent e) {
        this._executesToApplyToSecondaryEdits.add(new DocEventExt(e));
        SwingUtilities.invokeLater(() -> this.flush());
    }

    private void _executeRemove(DocumentEvent e, int lenOfIntermediatelyDoneInsertsOnPrimaryEdit) {
        try {
            this._updating = true;
            this.logDocEvt(e);
            int ancestorCount = 0;
            for (SingleEdit singleEdit : this._multiEdits.allButInitial()) {
                singleEdit.adjustByAncestorShift(-(++ancestorCount) * e.getLength());
                int editsRemoveStart = singleEdit.getStart() + (e.getOffset() - this._multiEdits.initial().getStart()) + lenOfIntermediatelyDoneInsertsOnPrimaryEdit;
                if (0 > editsRemoveStart || editsRemoveStart + e.getLength() >= this._textArea.getText().length()) continue;
                this._textArea.getDocument().remove(editsRemoveStart, e.getLength());
            }
        }
        catch (BadLocationException ex) {
            throw Utilities.wrapRuntime(ex);
        }
        finally {
            this._updating = false;
        }
    }

    private void logDocEvt(DocumentEvent e) {
    }

    private void flush() {
        if (this._executesToApplyToSecondaryEdits.isEmpty()) {
            return;
        }
        while (!this._executesToApplyToSecondaryEdits.isEmpty()) {
            DocEventExt docEventExt = this._executesToApplyToSecondaryEdits.remove(0);
            if (docEventExt.getEvent().getType() == DocumentEvent.EventType.REMOVE) {
                int lenOfIntermediatelyDoneInsertsOnPrimaryEdit = 0;
                for (DocEventExt extEvt : this._executesToApplyToSecondaryEdits) {
                    if (extEvt.getEvent().getType() != DocumentEvent.EventType.INSERT) continue;
                    lenOfIntermediatelyDoneInsertsOnPrimaryEdit += extEvt.getInsertString().length();
                }
                this._executeRemove(docEventExt.getEvent(), lenOfIntermediatelyDoneInsertsOnPrimaryEdit);
                continue;
            }
            if (docEventExt.getEvent().getType() != DocumentEvent.EventType.INSERT) continue;
            this._executeInsert(docEventExt.getEvent(), docEventExt.getInsertString());
        }
        SwingUtilities.invokeLater(() -> this._multiEdits.scrollToLastCaret());
    }

    public boolean isUpdating() {
        return this._updating;
    }
}

