/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret;

import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.EditorSpecifics;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class HighlightUtil {
    public static Object highlightRange(JTextArea textArea, int startPos, int endPos) {
        try {
            if (endPos <= startPos) {
                return null;
            }
            endPos = EditorSpecifics.adjustHiglightEndPos(textArea, endPos);
            DefaultHighlighter highlighter = (DefaultHighlighter)textArea.getHighlighter();
            highlighter.setDrawsLayeredHighlights(false);
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(textArea.getSelectionColor());
            Object highlightTag = highlighter.addHighlight(startPos, endPos, defaultHighlightPainter);
            return highlightTag;
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static void removeHighlight(JTextArea textArea, Object highLightTag) {
        if (null == highLightTag) {
            return;
        }
        DefaultHighlighter highlighter = (DefaultHighlighter)textArea.getHighlighter();
        highlighter.removeHighlight(highLightTag);
    }
}

