/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.session.editorpaint.EditorPaintService;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.DocumentMultiEditor;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.HighlightUtil;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiCaretPainter;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiCaretUtil;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiEdits;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.SingleEdit;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.apache.commons.lang3.StringUtils;

public class MultiCaretHandler {
    private MultiEdits _multiEdits;
    private MultiCaretPainter _multiCaretPainter;
    private JTextArea _textArea;
    private final EditorPaintService _editorPaintService;
    private DocumentMultiEditor _documentMultiEditor;

    public MultiCaretHandler(JTextArea textArea, EditorPaintService editorPaintService) {
        this._textArea = textArea;
        this._editorPaintService = editorPaintService;
        this._multiEdits = new MultiEdits(this._textArea);
        this._multiCaretPainter = new MultiCaretPainter(this._textArea, this._multiEdits);
        this._textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MultiCaretHandler.this.onKeyPressed(e);
            }
        });
        this._documentMultiEditor = new DocumentMultiEditor(this._textArea, this._multiEdits);
        this._textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiCaretHandler.this.onInsertUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiCaretHandler.this.onRemoveUpdate(e);
            }
        });
        this._textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MultiCaretUtil.isAdditionalCaretMouseClickModifier(e)) {
                    return;
                }
                MultiCaretHandler.this.clearMultiEdits();
            }
        });
    }

    private void onRemoveUpdate(DocumentEvent e) {
        if (this._multiEdits.isEmpty()) {
            return;
        }
        if (this._documentMultiEditor.isUpdating()) {
            return;
        }
        if (0 >= e.getLength()) {
            return;
        }
        if (this.isUndoRedoDocumentEvent(e)) {
            this.clearMultiEdits();
            return;
        }
        this._documentMultiEditor.executeRemove(e);
    }

    private boolean isUndoRedoDocumentEvent(DocumentEvent e) {
        return "javax.swing.text.AbstractDocument$UndoRedoDocumentEvent".equals(e.getClass().getName());
    }

    private void onInsertUpdate(DocumentEvent e) {
        if (this._multiEdits.isEmpty()) {
            return;
        }
        if (this._documentMultiEditor.isUpdating()) {
            return;
        }
        if (0 >= e.getLength()) {
            return;
        }
        if (this.isUndoRedoDocumentEvent(e)) {
            this.clearMultiEdits();
            return;
        }
        this._documentMultiEditor.executeInsert(e);
    }

    private void onKeyPressed(KeyEvent e) {
        if (this._multiEdits.isEmpty()) {
            return;
        }
        if (e.getKeyCode() == 27) {
            this.clearMultiEdits();
        } else {
            SwingUtilities.invokeLater(() -> this.adjustHighlights());
        }
    }

    private void adjustHighlights() {
        if (this._multiEdits.isEmpty()) {
            return;
        }
        int relativeSelectionStart = this._textArea.getSelectionStart() - this._textArea.getCaretPosition();
        int relativeSelectionEnd = this._textArea.getSelectionEnd() - this._textArea.getCaretPosition();
        int relativeCaretPosition = this._multiEdits.relativeCaretPosition();
        for (SingleEdit singleEdit : this._multiEdits.all()) {
            HighlightUtil.removeHighlight(this._textArea, singleEdit.getHighLightTag());
            int thisEditsCaretPos = singleEdit.getStart() + relativeCaretPosition;
            int thisEditsSelectionStart = thisEditsCaretPos + relativeSelectionStart;
            int thisEditsSelectionEnd = thisEditsCaretPos + relativeSelectionEnd;
            singleEdit.setHighLightTag(HighlightUtil.highlightRange(this._textArea, thisEditsSelectionStart, thisEditsSelectionEnd));
        }
        SwingUtilities.invokeLater(() -> this._multiEdits.scrollToLastCaret());
        SwingUtilities.invokeLater(() -> this._textArea.repaint());
    }

    public void removeLastCaret() {
        if (this._multiEdits.isEmpty()) {
            return;
        }
        HighlightUtil.removeHighlight(this._textArea, this._multiEdits.removeLast().getHighLightTag());
        if (this._multiEdits.isEmpty()) {
            this._textArea.setSelectionStart(this._textArea.getCaretPosition());
            this._textArea.setSelectionEnd(this._textArea.getCaretPosition());
        } else {
            this._textArea.scrollRectToVisible(GUIUtils.getRectangleOfPosition(this._textArea, this._multiEdits.last().getStart()));
        }
        if (!this._multiEdits.requiresMultipleCarets()) {
            this._editorPaintService.setPauseInsertPairedCharacters(false);
        }
        SwingUtilities.invokeLater(() -> this._textArea.repaint());
    }

    public void createNextCaret() {
        SingleEdit buf = this.getNextEdit();
        if (null == buf) {
            return;
        }
        boolean didRequireMultipleCarets = this._multiEdits.requiresMultipleCarets();
        this._multiEdits.add(buf);
        this.newCaret(this._multiEdits.last());
        if (!this._multiEdits.isEmpty() && this._multiEdits.last().isInitialEdit()) {
            this.createNextCaret();
        }
        if (!didRequireMultipleCarets && this._multiEdits.requiresMultipleCarets()) {
            this._editorPaintService.setPauseInsertPairedCharacters(true);
        }
        SwingUtilities.invokeLater(() -> this._textArea.repaint());
    }

    private void newCaret(SingleEdit singleEdit) {
        Object highlightTag = HighlightUtil.highlightRange(this._textArea, singleEdit.getStart(), singleEdit.getEnd());
        singleEdit.setHighLightTag(highlightTag);
        this._textArea.scrollRectToVisible(GUIUtils.getRectangleOfPosition(this._textArea, singleEdit.getStart()));
    }

    private void clearMultiEdits() {
        for (SingleEdit singleEdit : this._multiEdits.all()) {
            HighlightUtil.removeHighlight(this._textArea, singleEdit.getHighLightTag());
        }
        this._multiEdits.clear();
        if (!this._multiEdits.requiresMultipleCarets()) {
            this._editorPaintService.setPauseInsertPairedCharacters(false);
        }
    }

    private SingleEdit getNextEdit() {
        if (this._multiEdits.isEmpty()) {
            SingleEdit ret = new SingleEdit(this._textArea.getSelectedText(), this._textArea.getSelectionStart(), this._textArea.getSelectionEnd());
            ret.setInitialEdit(true);
            return ret;
        }
        int nextEditsStart = this._multiEdits.last().isEmptySelection() ? this.getNextEditsStartFromPositionInLine() : StringUtils.indexOfIgnoreCase((CharSequence)this._textArea.getText(), (CharSequence)this._multiEdits.last().getText(), (int)this._multiEdits.last().getEnd());
        if (-1 == nextEditsStart) {
            return null;
        }
        return new SingleEdit(this._multiEdits.last().getText(), nextEditsStart, nextEditsStart + this._multiEdits.last().getLength());
    }

    private int getNextEditsStartFromPositionInLine() {
        try {
            int previousEditsLine = this._textArea.getLineOfOffset(this._multiEdits.last().getStart());
            int previousEditsPositionInLine = this._multiEdits.last().getStart() - this._textArea.getLineStartOffset(previousEditsLine);
            int lineCount = this._textArea.getLineCount();
            for (int line = previousEditsLine + 1; line < lineCount; ++line) {
                if (this._textArea.getLineEndOffset(line) - 1 - this._textArea.getLineStartOffset(line) < previousEditsPositionInLine) continue;
                return this._textArea.getLineStartOffset(line) + previousEditsPositionInLine;
            }
            return -1;
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public void onPaintComponent(Graphics g) {
        this._multiCaretPainter.paintAdditionalCarets(g);
    }

    public void createNextCaretAtPoint(Point mousePoint) {
        if (this._multiEdits.isEmpty()) {
            SingleEdit singleEdit = new SingleEdit(null, this._textArea.getCaretPosition(), this._textArea.getCaretPosition());
            singleEdit.setInitialEdit(true);
            this._multiEdits.add(singleEdit);
        }
        int editorPosition = this._textArea.viewToModel2D(mousePoint);
        SingleEdit singleEdit = new SingleEdit(null, editorPosition, editorPosition);
        singleEdit.setInitialEdit(false);
        this._multiEdits.add(singleEdit);
        SwingUtilities.invokeLater(() -> this._textArea.repaint());
    }
}

