/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Position;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.EditorSpecificCaretData;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.EditorSpecifics;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.MultiEdits;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.SingleEdit;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class MultiCaretPainter {
    private final JTextArea _textArea;
    private final MultiEdits _multiEdits;
    private boolean _emptyRepaintDone;
    private Timer _repaintWithDelayBeyondPerceptiblyTimer;

    public MultiCaretPainter(JTextArea textArea, MultiEdits multiEdits) {
        this._textArea = textArea;
        this._multiEdits = multiEdits;
        this._repaintWithDelayBeyondPerceptiblyTimer = new Timer(50, e -> this._textArea.repaint());
        this._repaintWithDelayBeyondPerceptiblyTimer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintAdditionalCarets(Graphics g) {
        if (!this._multiEdits.requiresMultipleCarets()) {
            if (!this._emptyRepaintDone) {
                this.repaintWithDelayBeyondPerceptibly();
                this._emptyRepaintDone = true;
            }
            return;
        }
        this._emptyRepaintDone = false;
        if (this._textArea.getCaret().isVisible()) {
            int relativeCaretPosition = this._multiEdits.relativeCaretPosition();
            DefaultCaret defaultCaret = (DefaultCaret)this._textArea.getCaret();
            Position.Bias dotBias = defaultCaret.getDotBias();
            EditorSpecificCaretData editorSpecificCaretData = EditorSpecifics.getEditorSpecificCaretData(this._textArea);
            for (SingleEdit singleEdit : this._multiEdits.allButInitial()) {
                int additionalCaretsPosition = singleEdit.getStart() + relativeCaretPosition;
                if (additionalCaretsPosition < 0 || additionalCaretsPosition >= this._textArea.getText().length()) continue;
                Rectangle r = GUIUtils.getRectangleOfPosition(this._textArea, additionalCaretsPosition, dotBias);
                Color previousColor = g.getColor();
                try {
                    g.setColor(this._textArea.getCaretColor());
                    r.x -= editorSpecificCaretData.getCaretXDisplacement();
                    g.fillRect(r.x, r.y, editorSpecificCaretData.getCaretWidth(), r.height);
                }
                finally {
                    g.setColor(previousColor);
                }
            }
        }
        this.repaintWithDelayBeyondPerceptibly();
    }

    private void repaintWithDelayBeyondPerceptibly() {
        if (!this._repaintWithDelayBeyondPerceptiblyTimer.isRunning()) {
            this._repaintWithDelayBeyondPerceptiblyTimer.start();
        }
    }
}

