/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret;

import java.util.List;
import java.util.Stack;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.editorpaint.multicaret.SingleEdit;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class MultiEdits {
    private Stack<SingleEdit> _singleEditStack = new Stack();
    private JTextArea _textArea;

    public MultiEdits(JTextArea textArea) {
        this._textArea = textArea;
    }

    public void add(SingleEdit singleEdit) {
        this._singleEditStack.push(singleEdit);
    }

    public SingleEdit last() {
        return this._singleEditStack.peek();
    }

    public boolean isEmpty() {
        return this._singleEditStack.isEmpty();
    }

    public List<SingleEdit> all() {
        return this._singleEditStack;
    }

    public List<SingleEdit> allButInitial() {
        return this._singleEditStack.subList(1, this._singleEditStack.size());
    }

    public void clear() {
        this._singleEditStack.clear();
    }

    public SingleEdit removeLast() {
        return this._singleEditStack.pop();
    }

    public boolean requiresMultipleCarets() {
        return 1 < this._singleEditStack.size();
    }

    public SingleEdit initial() {
        return (SingleEdit)this._singleEditStack.firstElement();
    }

    public int relativeCaretPosition() {
        int caretPosition = this._textArea.getCaretPosition();
        SingleEdit realCaretAnchor = this.initial();
        int relativeCaretPosition = caretPosition - realCaretAnchor.getStart();
        return relativeCaretPosition;
    }

    public void scrollToLastCaret() {
        if (!this.requiresMultipleCarets()) {
            return;
        }
        this._textArea.scrollRectToVisible(GUIUtils.getRectangleOfPosition(this._textArea, this.last().getStart() + this.relativeCaretPosition()));
    }
}

