/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.util.HashMap;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileChooserViewType;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;

public class FileChooserManager {
    private static final String PREF_PRE_SELECTED_FILE_FILTER = "Squirrel.filechoosermanager.preselfilefilter";
    private static final String PREF_FILE_CHOOSER_VIEW_TYPE = "Squirrel.filechoosermanager.fileChooserViewType";
    public static final String FILE_ENDING_TXT = ".txt";
    public static final String FILE_ENDING_SQL = ".sql";
    public static final String FILE_ENDING_NONE = "FILE_ENDING_NONE";
    private HashMap<FileExtensionFilter, String> _fileAppenixes = new HashMap();
    private FileExtensionFilter _txtFilter = new FileExtensionFilter("Text files", new String[]{".txt"});
    private FileExtensionFilter _sqlFilter;
    private boolean _saveFileFilterProps = true;
    private JFileChooser _currentFileChooser;

    public FileChooserManager() {
        this._fileAppenixes.put(this._txtFilter, FILE_ENDING_TXT);
        this._sqlFilter = new FileExtensionFilter("SQL files", new String[]{FILE_ENDING_SQL});
        this._fileAppenixes.put(this._sqlFilter, FILE_ENDING_SQL);
        this.initNewFileChooser();
    }

    public String getSelectedFileEnding() {
        return this._fileAppenixes.get(this._currentFileChooser.getFileFilter());
    }

    public JFileChooser initNewFileChooser() {
        this._currentFileChooser = new JFileChooser();
        this._currentFileChooser.addChoosableFileFilter(this._txtFilter);
        this._currentFileChooser.addChoosableFileFilter(this._sqlFilter);
        String fileEndingPref = Props.getString(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        if (FILE_ENDING_SQL.equals(fileEndingPref)) {
            this._currentFileChooser.setFileFilter(this._sqlFilter);
        } else if (FILE_ENDING_TXT.equals(fileEndingPref)) {
            this._currentFileChooser.setFileFilter(this._txtFilter);
        }
        String viewTypeName = Props.getString(PREF_FILE_CHOOSER_VIEW_TYPE, FileChooserViewType.DETAILS.name());
        FileChooserViewType.valueOf(viewTypeName).tryApplyViewType(this._currentFileChooser);
        return this._currentFileChooser;
    }

    public void saveDisplayPrefs() {
        FileChooserViewType fileChooserViewType = FileChooserViewType.tryExtractChooserViewType(this._currentFileChooser);
        Props.putString(PREF_FILE_CHOOSER_VIEW_TYPE, fileChooserViewType.name());
    }

    public void saveWasApproved() {
        if (!this._saveFileFilterProps) {
            return;
        }
        if (null != this.getSelectedFileEnding()) {
            Props.putString(PREF_PRE_SELECTED_FILE_FILTER, this.getSelectedFileEnding());
        } else {
            Props.putString(PREF_PRE_SELECTED_FILE_FILTER, FILE_ENDING_NONE);
        }
        this.saveDisplayPrefs();
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter) {
        this._sqlFilter = fileExtensionFilter;
        this._saveFileFilterProps = false;
    }
}

