/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.awt.Component;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public enum FileChooserViewType {
    DETAILS("viewTypeDetails", "Details"),
    LIST("viewTypeList", "List");

    private static final ILogger s_log;
    private static boolean logApplyViewTypeFailure;
    private static boolean logTryExtractChooserViewTypeFailure;
    private final String _fileChooserActionMapKey;
    private final String _fileViewName;

    private FileChooserViewType(String fileChooserActionMapKey, String fileViewName) {
        this._fileChooserActionMapKey = fileChooserActionMapKey;
        this._fileViewName = fileViewName;
    }

    public static FileChooserViewType tryExtractChooserViewType(JFileChooser fileChooser) {
        FileChooserViewType ret;
        block6: {
            ret = DETAILS;
            try {
                FileView fileView = fileChooser.getFileView();
                if (null != fileView) {
                    if (StringUtils.containsIgnoreCase((CharSequence)fileView.getClass().getName(), (CharSequence)"list")) {
                        ret = LIST;
                    }
                    break block6;
                }
                for (Component component : fileChooser.getComponents()) {
                    Object viewTypeAsObject;
                    if (!component.getClass().getName().equals("sun.swing.FilePane") || !((viewTypeAsObject = component.getClass().getMethod("getViewType", new Class[0]).invoke((Object)component, new Object[0])) instanceof Integer)) continue;
                    int viewType = (Integer)viewTypeAsObject;
                    if (viewType == 0) {
                        ret = LIST;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!logTryExtractChooserViewTypeFailure) break block6;
                logTryExtractChooserViewTypeFailure = false;
                s_log.warn("Failed to determine FileChooserViewType. Will use " + ret.name() + " as fallback", e);
            }
        }
        return ret;
    }

    public void tryApplyViewType(JFileChooser fileChooser) {
        block2: {
            try {
                fileChooser.getActionMap().get(this._fileChooserActionMapKey).actionPerformed(null);
            }
            catch (Exception e) {
                if (!logApplyViewTypeFailure) break block2;
                logApplyViewTypeFailure = false;
                s_log.warn("Failed to apply FileChooserViewType " + this.name(), e);
            }
        }
    }

    static {
        s_log = LoggerController.createLogger(FileChooserViewType.class);
        logApplyViewTypeFailure = true;
        logTryExtractChooserViewTypeFailure = true;
    }
}

