/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FileChooserWithMoveOptionDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileChooserWithMoveOptionDialog.class);
    private JFileChooser _fileChooser;
    private JCheckBox _chkMoveFile;
    private File _selectedFile;

    public FileChooserWithMoveOptionDialog(JFileChooser fileChooser, Frame parent) {
        super(parent, true);
        this.setTitle(s_stringMgr.getString("FileChooserWithMoveOptionDialog.title"));
        this._fileChooser = fileChooser;
        this.buildUI();
        this._fileChooser.addActionListener(e -> this.onFileChooserButtonClicked(e.getActionCommand()));
        GUIUtils.enableCloseByEscape(this);
    }

    private void onFileChooserButtonClicked(String actionCommand) {
        if ("ApproveSelection".equals(actionCommand)) {
            this._selectedFile = this._fileChooser.getSelectedFile();
        }
        this.close();
    }

    public void setSelectedFile(File fileToSaveAs) {
        this._fileChooser.setSelectedFile(fileToSaveAs);
    }

    public void setCurrentDirectory(File file) {
        this._fileChooser.setCurrentDirectory(file);
    }

    public File getSelectedFile() {
        return this._fileChooser.getSelectedFile();
    }

    public int showSaveDialog() {
        if (null == this._fileChooser.getSelectedFile()) {
            this._chkMoveFile.setEnabled(false);
        }
        this._fileChooser.setDialogType(1);
        this.pack();
        GUIUtils.centerWithinParent(this);
        this.setVisible(true);
        if (null != this._selectedFile) {
            return 0;
        }
        return 1;
    }

    public boolean isMoveFile() {
        return this._chkMoveFile.isSelected();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void buildUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this._fileChooser, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 10, 0), 0, 0);
        this._chkMoveFile = new JCheckBox(s_stringMgr.getString("FileChooserWithMoveOptionDialog.move.file"));
        this.getContentPane().add((Component)this._chkMoveFile, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 5), 0, 0);
        this.getContentPane().add((Component)new SmallToolTipInfoButton(s_stringMgr.getString("FileChooserWithMoveOptionDialog.move.file.info.html")).getButton(), gbc);
    }
}

