/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.awt.Window;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.action.file.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileChangeType;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileHandlerListener;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementCore;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementUtil;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileNotifierListener;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileReloadInfo;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileSaveResult;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.util.PrintUtilities;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainDialog;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainResult;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class FileHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileHandler.class);
    private final FileManagementCore _fileManagementCore;
    private IFileEditorAPI _fileEditorAPI;
    private boolean _fileOpened = false;
    private boolean _fileSaved = false;
    private boolean _unsavedEdits = false;
    private FileHandlerListener _fileHandlerListener;

    public FileHandler(IFileEditorAPI fileEditorAPI, TitleFilePathHandler titleFileHandler) {
        this._fileManagementCore = new FileManagementCore(fileEditorAPI, titleFileHandler);
        this._fileEditorAPI = fileEditorAPI;
        FileNotifierListener fileNotifierListener = file -> this.fileReload(new FileReloadInfo(file));
        Main.getApplication().getFileNotifier().addFileNotifierListener(fileNotifierListener);
        this._fileEditorAPI.getSession().addSimpleSessionListener(() -> Main.getApplication().getFileNotifier().removeFileNotifierListener(fileNotifierListener));
    }

    public IFileEditorAPI getFileEditorAPI() {
        return this._fileEditorAPI;
    }

    public boolean fileSave() {
        if (this._fileManagementCore.save()) {
            this._fileSaved = true;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(false);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
            this.fireFileHandlerListener();
            return true;
        }
        return false;
    }

    public void fileAppend() {
        if (this._fileManagementCore.open(true)) {
            this._fileOpened = true;
            this._fileSaved = false;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(this._unsavedEdits);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, true);
            this.fireFileHandlerListener();
        }
    }

    public void fileClose() {
        this._closeFile(true, false);
    }

    public void fileReload(FileReloadInfo info) {
        File file = this._fileManagementCore.getFile();
        if (info.isByUserRequest()) {
            if (null == file) {
                Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SQLPanelAPI.nofileToRelaod"));
                return;
            }
        } else {
            if (!Utilities.equalsRespectNull(info.getFile(), file)) {
                return;
            }
            DontShowAgainDialog reloadReqDlg = new DontShowAgainDialog((Window)this._fileEditorAPI.getOwningFrame(), s_stringMgr.getString("FileHandler.fileChangeDetected.ReloadRequest", file.getAbsolutePath()), s_stringMgr.getString("FileHandler.fileChangeDetected.switchBackOnHint"));
            DontShowAgainResult reloadReqRes = reloadReqDlg.showAndGetResult("FileHandler.fileChangeDetected", 470, 200);
            if (reloadReqRes.isDontShowAgain()) {
                Main.getApplication().getFileNotifier().setNotifyExternalFileChanges(false);
            }
            if (!reloadReqRes.isYes()) {
                return;
            }
        }
        int caretPosition = this._fileEditorAPI.getCaretPosition();
        if (!this._closeFile(true, false)) {
            return;
        }
        this.fileOpen(file);
        this._fileEditorAPI.setCaretPosition(Math.min(this._fileEditorAPI.getText().length(), caretPosition));
        this.fireFileHandlerListener();
    }

    public void fileOpen() {
        if (this._unsavedEdits && !this.showConfirmSaveDialog()) {
            return;
        }
        if (this._fileManagementCore.open(false)) {
            this._fileOpened = true;
            this._fileSaved = false;
            this._unsavedEdits = false;
            this.displayUnsavedEditsInTabComponent(this._unsavedEdits);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
        this._fileEditorAPI.setCaretPosition(0);
        this.fireFileHandlerListener();
    }

    public void fileOpen(File f) {
        this.fileOpen(f, false);
    }

    public void fileOpen(File f, boolean append) {
        if (this._unsavedEdits) {
            this.showConfirmSaveDialog();
        }
        if (!this._fileManagementCore.open(f, append)) {
            return;
        }
        this._fileOpened = true;
        this._fileSaved = false;
        this._unsavedEdits = false;
        this.displayUnsavedEditsInTabComponent(false);
        ActionCollection actions = Main.getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, false);
        this._fileEditorAPI.setCaretPosition(0);
        this.fireFileHandlerListener();
    }

    public void fileNew() {
        this.fileClose();
    }

    public void fileDetach() {
        this.fileDetach(false);
    }

    public void fileDetach(boolean silently) {
        this._closeFile(false, silently);
    }

    public FileSaveResult fileSaveAs() {
        FileSaveResult fileSaveResult = this._fileManagementCore.saveAs();
        if (fileSaveResult.isSuccess()) {
            this.onInitiallySaved();
        }
        return fileSaveResult;
    }

    public void fileSaveInitiallyTo(File toFile) {
        if (this._fileManagementCore.saveInitiallyTo(toFile)) {
            this.onInitiallySaved();
        }
    }

    private void onInitiallySaved() {
        this._fileSaved = true;
        this._unsavedEdits = false;
        this.displayUnsavedEditsInTabComponent(false);
        ActionCollection actions = Main.getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, false);
        this.fireFileHandlerListener();
    }

    public boolean showConfirmCloseIfNecessary() {
        if (this._unsavedEdits) {
            return this.showConfirmSaveDialog();
        }
        return true;
    }

    public void resetUnsavedEdits() {
        this._unsavedEdits = false;
    }

    public void filePrint() {
        PrintUtilities.printComponent(this._fileEditorAPI.getTextComponent());
    }

    private boolean _closeFile(boolean clearEditor, boolean silently) {
        if (this._unsavedEdits && !silently && !this.showConfirmSaveDialog()) {
            return false;
        }
        if (clearEditor) {
            this._fileEditorAPI.setEntireSQLScript("");
        }
        this.clearSqlFile();
        this._fileOpened = false;
        this._fileSaved = false;
        this._unsavedEdits = false;
        ActionCollection actions = Main.getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, true);
        this._fileManagementCore.clearCurrentFile();
        this.fireFileHandlerListener(false, FileChangeType.FILE_CLOSED);
        return true;
    }

    private boolean showConfirmSaveDialog() {
        File file = this._fileManagementCore.getFile();
        String filename = s_stringMgr.getString("SQLPanelAPI.untitledLabel");
        if (file != null) {
            filename = file.getAbsolutePath();
        }
        String msg = s_stringMgr.getString("SQLPanelAPI.unsavedchanges", filename);
        boolean isBufferEdit = null == file;
        String switchBackOnHowTo = isBufferEdit ? s_stringMgr.getString("SQLPanelAPI.switchBackOnHowTo.buffer") : s_stringMgr.getString("SQLPanelAPI.switchBackOnHowTo.file");
        String title = s_stringMgr.getString("SQLPanelAPI.unsavedchangestitle", this._fileEditorAPI.getSession().getAlias().getName());
        JFrame owner = (JFrame)this._fileEditorAPI.getOwningFrame();
        DontShowAgainDialog dontShowAgainDialog = new DontShowAgainDialog((Window)owner, msg, switchBackOnHowTo);
        dontShowAgainDialog.setTitle(title);
        DontShowAgainResult res = dontShowAgainDialog.showAndGetResult("FileHandler.dontShowgAgainId", 470, 200);
        if (res.isDontShowAgain()) {
            if (isBufferEdit) {
                Main.getApplication().getSquirrelPreferences().setWarnForUnsavedBufferEdits(false);
            } else {
                Main.getApplication().getSquirrelPreferences().setWarnForUnsavedFileEdits(false);
            }
        }
        if (res.isYes()) {
            return this.fileSave();
        }
        return !res.isCancel();
    }

    public UndoableEditListener createEditListener() {
        return e -> this.onEditHappened(e);
    }

    public void onEditHappened(UndoableEditEvent e) {
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        if (this._fileOpened || this._fileSaved) {
            if (prefs.getWarnForUnsavedFileEdits()) {
                this._unsavedEdits = true;
            }
            this.displayUnsavedEditsInTabComponent(true);
            ActionCollection actions = Main.getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, true);
        } else if (prefs.getWarnForUnsavedBufferEdits()) {
            this._unsavedEdits = true;
        }
    }

    private void clearSqlFile() {
        this._fileManagementCore.clearSqlFile();
    }

    private void displayUnsavedEditsInTabComponent(boolean b) {
        this._fileManagementCore.displayUnsavedEditsInTabComponent(b);
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter) {
        this._fileManagementCore.replaceSqlFileExtensionFilterBy(fileExtensionFilter);
    }

    public void setFileHandlerListener(FileHandlerListener fileHandlerListener) {
        this._fileHandlerListener = fileHandlerListener;
        this.fireFileHandlerListener(true, FileChangeType.FILE_CHANGED);
    }

    private void fireFileHandlerListener() {
        this.fireFileHandlerListener(false, FileChangeType.FILE_CHANGED);
    }

    private void fireFileHandlerListener(boolean reReadFile, FileChangeType fileChangeType) {
        if (null == this._fileHandlerListener) {
            return;
        }
        if (fileChangeType == FileChangeType.FILE_CLOSED) {
            this._fileHandlerListener.fileChanged(null);
            return;
        }
        if (fileChangeType == FileChangeType.FILE_CHANGED && null != this._fileManagementCore.getFile()) {
            if (reReadFile) {
                this._fileHandlerListener.fileChanged(FileManagementUtil.readFileAsString(this._fileManagementCore.getFile()));
            } else {
                this._fileHandlerListener.fileChanged(this._fileEditorAPI.getEntireSQLScript());
            }
        }
    }

    public File getFile() {
        return this._fileManagementCore.getFile();
    }

    public byte[] getBytesForSave() {
        return this._fileManagementCore.getBytesForSave();
    }
}

