/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.action.savedsession.SavedSessionUtil;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileChooserManager;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileChooserWithMoveOptionDialog;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileKeeper;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementUtil;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileSaveResult;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.filechooser.PreviewFileChooser;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FileManagementCore {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileManagementCore.class);
    private static ILogger s_log = LoggerController.createLogger(FileManagementCore.class);
    private IFileEditorAPI _fileEditorAPI;
    private TitleFilePathHandler _titleFilePathHandler;
    private FileKeeper _toSaveTo = new FileKeeper();
    private FileChooserManager _fileChooserManager = new FileChooserManager();
    private IOUtilities ioUtil = new IOUtilitiesImpl();

    public FileManagementCore(IFileEditorAPI fileEditorAPI, TitleFilePathHandler titleFilePathHandler) {
        this._fileEditorAPI = fileEditorAPI;
        if (null == titleFilePathHandler) {
            throw new IllegalStateException("titleFilePathHandler must not be null");
        }
        this._titleFilePathHandler = titleFilePathHandler;
    }

    public boolean save() {
        return this.saveIntern(false).isSuccess();
    }

    public FileSaveResult saveAs() {
        return this.saveIntern(true);
    }

    public boolean saveInitiallyTo(File toFile) {
        return this.saveScript(this._fileEditorAPI.getOwningFrame(), toFile, false);
    }

    public boolean open(File f, boolean appendToExisting) {
        this._fileEditorAPI.selectWidgetOrTab();
        return this.loadScript(f, appendToExisting);
    }

    public boolean open(boolean appendToExisting) {
        boolean result = false;
        JFileChooser chooser = this._fileChooserManager.initNewFileChooser();
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        if (prefs.isFileOpenInPreviousDir()) {
            String fileName = prefs.getFilePreviousDir();
            if (fileName != null) {
                chooser.setCurrentDirectory(new File(fileName));
            }
        } else {
            String dirName = prefs.getFileSpecifiedDir();
            if (dirName != null) {
                chooser.setCurrentDirectory(new File(dirName));
            }
        }
        Frame frame = this._fileEditorAPI.getOwningFrame();
        this._fileEditorAPI.selectWidgetOrTab();
        if (PreviewFileChooser.showOpenDialog(frame, chooser) == 0) {
            File selectedFile = chooser.getSelectedFile();
            result = this.loadScript(selectedFile, appendToExisting);
        }
        this._fileChooserManager.saveDisplayPrefs();
        return result;
    }

    private String checkFileOk(File selectedFile) {
        String errorMessage = null;
        if (null == selectedFile) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.no.file.selected");
        } else if (!selectedFile.exists()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.does.not.exist", selectedFile.getAbsolutePath());
        } else if (!selectedFile.isFile()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.is.not.a.file", selectedFile.getAbsolutePath());
        } else if (!selectedFile.canRead()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.can.not.be.read", selectedFile.getAbsolutePath());
        }
        return errorMessage;
    }

    private boolean loadScript(File file, boolean appendToExisting) {
        String errorMessage = this.checkFileOk(file);
        if (null != errorMessage) {
            String titel = s_stringMgr.getString("FileManager.error.file.open.failed.title");
            JOptionPane.showMessageDialog(this._fileEditorAPI.getOwningFrame(), errorMessage, titel, 0);
            Main.getApplication().getMessageHandler().showErrorMessage(errorMessage);
            return false;
        }
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        try {
            StringBuffer sb = FileManagementUtil.readFile(file);
            if (!appendToExisting) {
                this._fileEditorAPI.setEntireSQLScript("");
            }
            this._fileEditorAPI.appendSQLScript(this.convertPlatformEOLToLineFeed(sb.toString()), true);
            this.setFile(file);
            this.memorizeFile(file, prefs);
            return true;
        }
        catch (Exception e) {
            Main.getApplication().getMessageHandler().showErrorMessage(e);
            s_log.error(e);
            return false;
        }
    }

    private void memorizeFile(File file, SquirrelPreferences prefs) {
        if (SavedSessionUtil.isInSavedSessionsDir(file)) {
            return;
        }
        prefs.setFilePreviousDir(file.getAbsolutePath());
        Main.getApplication().getRecentFilesManager().fileTouched(file.getAbsolutePath(), this._fileEditorAPI.getSession().getAlias());
    }

    private FileSaveResult saveIntern(boolean toNewFile) {
        FileSaveResult result = new FileSaveResult(false);
        File toSaveToBuf = null;
        boolean wasSavedToNewFile = false;
        Frame frame = this._fileEditorAPI.getOwningFrame();
        FileChooserWithMoveOptionDialog chooser = new FileChooserWithMoveOptionDialog(this._fileChooserManager.initNewFileChooser(), frame);
        if (toNewFile) {
            toSaveToBuf = this._toSaveTo.get();
            this._toSaveTo.set(null);
            chooser.setSelectedFile(toSaveToBuf);
        }
        SquirrelPreferences prefs = this._fileEditorAPI.getSession().getApplication().getSquirrelPreferences();
        if (null == this._toSaveTo.get()) {
            if (prefs.isFileOpenInPreviousDir()) {
                String dirName = prefs.getFilePreviousDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            } else {
                String dirName = prefs.getFileSpecifiedDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            }
        }
        this._fileEditorAPI.selectWidgetOrTab();
        if (null != this._toSaveTo.get()) {
            if (this.saveScript(frame, this._toSaveTo.get(), false)) {
                result.setSuccess(true);
            }
        } else if (chooser.showSaveDialog() == 0) {
            this._fileChooserManager.saveWasApproved();
            this._toSaveTo.set(chooser.getSelectedFile());
            if (!this._toSaveTo.get().exists() && null != this._fileChooserManager.getSelectedFileEnding() && !this._toSaveTo.get().getAbsolutePath().endsWith(this._fileChooserManager.getSelectedFileEnding())) {
                this._toSaveTo.set(new File(this._toSaveTo.get().getAbsolutePath() + this._fileChooserManager.getSelectedFileEnding()));
            }
            if (this.saveScript(frame, this._toSaveTo.get(), true)) {
                result.setSuccess(true);
                wasSavedToNewFile = true;
                result.setSavedToNewFile(toSaveToBuf, this._toSaveTo.get(), chooser.isMoveFile());
            } else {
                this._toSaveTo.set(null);
                result.setSuccess(false);
            }
        }
        this._fileChooserManager.saveDisplayPrefs();
        if (!wasSavedToNewFile && null != toSaveToBuf) {
            this._toSaveTo.set(toSaveToBuf);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveScript(Frame frame, File file, boolean askReplace) {
        boolean doSave = false;
        if (file.exists() && !file.canWrite()) {
            String msg = s_stringMgr.getString("FileManager.error.cannotwritefile", file.getAbsolutePath());
            s_log.warn(msg);
            Dialogs.showOk(frame, msg);
            return false;
        }
        try {
            file.toPath();
        }
        catch (InvalidPathException e) {
            s_log.error("Invalid file name: Call to File.toPath() raised error", e);
            String msg = s_stringMgr.getString("FileManager.error.invalid.file.name", file.getAbsolutePath(), Utilities.getExceptionStringSave(e));
            s_log.error(msg, e);
            Dialogs.showError(frame, msg);
            return false;
        }
        if (askReplace && file.exists()) {
            String confirmMsg = s_stringMgr.getString("FileManager.confirm.filereplace", file.getAbsolutePath());
            doSave = Dialogs.showYesNo(frame, confirmMsg);
            if (!doSave) {
                return false;
            }
            file.delete();
        } else {
            doSave = true;
        }
        SquirrelPreferences prefs = this._fileEditorAPI.getSession().getApplication().getSquirrelPreferences();
        if (doSave) {
            this.memorizeFile(file, prefs);
            Main.getApplication().getFileNotifier().beginFileWrite(file);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(this.getBytesForSave());
                this.setFile(file);
                String msg = s_stringMgr.getString("FileManager.savedfile", file.getAbsolutePath());
                this._fileEditorAPI.getSession().showMessage(msg);
            }
            catch (IOException ex) {
                this._fileEditorAPI.getSession().showErrorMessage(ex);
            }
            finally {
                this.ioUtil.closeOutputStream(fos);
                Main.getApplication().getFileNotifier().endFileWrite(file);
            }
        }
        return true;
    }

    private String getEntireSQLScriptWithPlatformEolChar() {
        String result = this._fileEditorAPI.getEntireSQLScript();
        return this.convertLineFeedToPlatformEOL(result);
    }

    private String convertLineFeedToPlatformEOL(String result) {
        String platformEolStr = StringUtilities.getEolStr();
        if (result != null && !"".equals(result)) {
            result = result.replaceAll("\\r", "");
            if (!platformEolStr.equals("\n")) {
                result = result.replaceAll("\\n", platformEolStr);
            }
        }
        return result;
    }

    private String convertPlatformEOLToLineFeed(String s) {
        String platformEolStr = StringUtilities.getEolStr();
        if (null == s || "".equals(s)) {
            return s;
        }
        if (!platformEolStr.equals("\n")) {
            s = s.replaceAll(platformEolStr, "\n");
        }
        return s.replaceAll("\\r", "");
    }

    private void setFile(File file) {
        this._toSaveTo.set(file);
        this._titleFilePathHandler.setSqlFile(file);
    }

    public File getFile() {
        return this._toSaveTo.get();
    }

    public void clearCurrentFile() {
        this._toSaveTo.set(null);
    }

    public void clearSqlFile() {
        this._titleFilePathHandler.setSqlFile(null);
    }

    public void displayUnsavedEditsInTabComponent(boolean unsavedEdits) {
        this._titleFilePathHandler.setUnsavedEdits(unsavedEdits);
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter) {
        this._fileChooserManager.replaceSqlFileExtensionFilterBy(fileExtensionFilter);
    }

    public byte[] getBytesForSave() {
        String sScript = this.getEntireSQLScriptWithPlatformEolChar();
        return sScript.getBytes();
    }
}

