/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileNotifierListener;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileWatch;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FileNotifier {
    private static ILogger s_log = LoggerController.createLogger(FileNotifier.class);
    private ArrayList<FileNotifierListener> _fileNotifierListeners = new ArrayList();
    private final Timer _swingTimer;
    private HashSet<File> _filesBeingWritten = new HashSet();
    private HashSet<FileWatch> _fileWatches = new HashSet();
    private boolean _inOnTimerTriggered;

    public FileNotifier() {
        this._swingTimer = new Timer(2000, e -> this.onTimerTriggered());
        this._swingTimer.setRepeats(true);
        this._swingTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimerTriggered() {
        if (!Main.getApplication().getSquirrelPreferences().isNotifyExternalFileChanges()) {
            this._swingTimer.stop();
            return;
        }
        if (this._inOnTimerTriggered) {
            return;
        }
        try {
            FileWatch[] fileWatches;
            this._inOnTimerTriggered = true;
            FileNotifierListener[] listeners = null;
            HashSet<FileWatch> updatedWatches = new HashSet<FileWatch>();
            for (FileWatch fileWatch : fileWatches = this._fileWatches.toArray(new FileWatch[0])) {
                if (!fileWatch.changedExternally() || this._filesBeingWritten.contains(fileWatch.getFile())) continue;
                if (null == listeners) {
                    listeners = this._fileNotifierListeners.toArray(new FileNotifierListener[0]);
                }
                for (FileNotifierListener listener : listeners) {
                    try {
                        listener.fileChanged(fileWatch.getFile());
                    }
                    catch (Exception e) {
                        s_log.error(e);
                    }
                }
                updatedWatches.add(new FileWatch(fileWatch.getFile()));
            }
            this._fileWatches.removeAll(updatedWatches);
            this._fileWatches.addAll(updatedWatches);
        }
        finally {
            this._inOnTimerTriggered = false;
        }
    }

    public void watchFile(File file) {
        this._fileWatches.remove(new FileWatch(file));
        this._fileWatches.add(new FileWatch(file));
    }

    public void unwatchFile(File file) {
        this._fileWatches.remove(new FileWatch(file));
    }

    public void addFileNotifierListener(FileNotifierListener fileNotifierListener) {
        this.removeFileNotifierListener(fileNotifierListener);
        this._fileNotifierListeners.add(fileNotifierListener);
    }

    public void removeFileNotifierListener(FileNotifierListener fileNotifierListener) {
        this._fileNotifierListeners.remove(fileNotifierListener);
    }

    public void setNotifyExternalFileChanges(boolean b) {
        if (!b) {
            this._swingTimer.stop();
        }
        Main.getApplication().getSquirrelPreferences().setNotifyExternalFileChanges(b);
    }

    public void beginFileWrite(File file) {
        this._filesBeingWritten.add(file);
    }

    public void endFileWrite(File file) {
        this._fileWatches.remove(new FileWatch(file));
        this._fileWatches.add(new FileWatch(file));
        this._filesBeingWritten.remove(file);
    }
}

