/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CancelPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelPanel.class);
    JLabel sqlLbl = new JLabel();
    JLabel currentStatusLbl = new JLabel();
    JButton cancelBtn;
    JButton closeBtn;
    JTextField txtExecTimeCounter;
    JTextField txtNumberOfRowsRead;
    JCheckBox chkPlaySoundWhenFinished;
    JButton btnConfigureFinishedSound;
    JButton btnCopySqlToClip;
    JButton btnShowExecutingSql;

    public CancelPanel(ISession session) {
        super(new BorderLayout());
        this.add((Component)this.createNorthPanel(session), "North");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    private JPanel createNorthPanel(ISession session) {
        JPanel ret = new JPanel(new BorderLayout());
        ImageIcon icon = session.getApplication().getResources().getIcon("close");
        this.closeBtn = new JButton(icon);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.setMargin(new Insets(0, 0, 0, 0));
        ret.add((Component)this.closeBtn, "East");
        ret.add((Component)new JPanel(), "Center");
        return ret;
    }

    private JPanel createCenterPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.cancelBtn = new JButton(s_stringMgr.getString("SQLResultExecuterPanel.cancelButtonLabel"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 10, 5, 10), 0, 0);
        ret.add((Component)this.createSQLLabelWithButtons(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 10, 0, 10), 0, 0);
        ret.add((Component)this.sqlLbl, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.statusLabel")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0);
        ret.add((Component)this.currentStatusLbl, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0);
        ret.add((Component)this.cancelBtn, gbc);
        gbc = new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(30, 10, 0, 10), 0, 0);
        ret.add((Component)this.createExecutionTimePanel(), gbc);
        gbc = new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(30, 10, 0, 10), 0, 0);
        ret.add((Component)this.createNotificationPanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JPanel createSQLLabelWithButtons() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.sqlLabel")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnCopySqlToClip = new JButton(Main.getApplication().getResources().getIcon("copySQL"));
        this.btnCopySqlToClip.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.copy.executing.sql.to.clipboard"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnCopySqlToClip), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 1, 0, 0), 0, 0);
        this.btnShowExecutingSql = new JButton(Main.getApplication().getResources().getIcon("sql"));
        this.btnShowExecutingSql.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.show.executing.sql"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnShowExecutingSql), gbc);
        return ret;
    }

    private JPanel createNotificationPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.chkPlaySoundWhenFinished = new JCheckBox(s_stringMgr.getString("SQLResultExecuterPanel.playWhenFinishedNotificationSound"));
        ret.add((Component)this.chkPlaySoundWhenFinished, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.btnConfigureFinishedSound = new JButton(s_stringMgr.getString("SQLResultExecuterPanel.configureWhenFinishedNotificationSound"));
        ret.add((Component)this.btnConfigureFinishedSound, gbc);
        return ret;
    }

    private JPanel createExecutionTimePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.executingFor")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.txtExecTimeCounter = new JTextField();
        this.txtExecTimeCounter.setEditable(false);
        this.txtExecTimeCounter.setColumns(10);
        GUIUtils.forceWidth(this.txtExecTimeCounter, 120);
        ret.add((Component)this.txtExecTimeCounter, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.execMillis")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("SQLResultExecuterPanel.numberOfRowsRead")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.txtNumberOfRowsRead = new JTextField();
        this.txtNumberOfRowsRead.setEditable(false);
        this.txtNumberOfRowsRead.setColumns(10);
        GUIUtils.forceWidth(this.txtNumberOfRowsRead, 120);
        ret.add((Component)this.txtNumberOfRowsRead, gbc);
        return ret;
    }
}

