/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Dimension;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TimerHolder;
import net.sourceforge.squirrel_sql.client.session.mainpanel.notificationsound.FinishedNotificationSoundHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

class CancelPanelCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelPanelCtrl.class);
    private CancelPanel _panel;
    private FinishedNotificationSoundHandler _finishedNotificationSoundHandler;
    private int _queryCount;
    private int _currentQueryIndex = 0;
    private CancelPanelListener _listener;
    private final TimerHolder _timer;
    private QueryHolder _currentSql;

    CancelPanelCtrl(CancelPanelListener listener, ISession session, FinishedNotificationSoundHandler finishedNotificationSoundHandler) {
        this._listener = listener;
        this._panel = new CancelPanel(session);
        this._finishedNotificationSoundHandler = finishedNotificationSoundHandler;
        this._panel.cancelBtn.addActionListener(e -> this.onCancel());
        this._panel.btnCopySqlToClip.addActionListener(e -> this.onCopyCurrentSqlToClip());
        this._panel.btnShowExecutingSql.addActionListener(e -> this.onShowCurrentSql());
        this._panel.closeBtn.addActionListener(e -> this.onClose());
        this._panel.chkPlaySoundWhenFinished.addActionListener(e -> this._finishedNotificationSoundHandler.onPlayFinishedSoundChecked(this._panel.chkPlaySoundWhenFinished.isSelected()));
        this._panel.btnConfigureFinishedSound.addActionListener(e -> this._finishedNotificationSoundHandler.onConfigureFinishedSound(this._panel));
        this._timer = new TimerHolder(this._panel.txtExecTimeCounter, this._panel.txtNumberOfRowsRead, this._panel.chkPlaySoundWhenFinished, this._finishedNotificationSoundHandler);
    }

    void incCurrentQueryIndex() {
        ++this._currentQueryIndex;
    }

    void setSQL(QueryHolder queryHolder) {
        GUIUtils.processOnSwingEventThread(() -> this.onSetSql(queryHolder));
    }

    private void onSetSql(QueryHolder sql) {
        this._currentSql = sql;
        String label = s_stringMgr.getString("SQLResultExecuterPanel.currentSQLLabel", String.valueOf(this._currentQueryIndex), String.valueOf(this._queryCount), sql.getCleanQuery());
        this._panel.sqlLbl.setText(label);
    }

    private void onCopyCurrentSqlToClip() {
        if (null == this._currentSql || StringUtilities.isEmpty(this._currentSql.getOriginalQuery(), true)) {
            return;
        }
        ClipboardUtil.copyToClip(this._currentSql.getOriginalQuery());
    }

    private void onShowCurrentSql() {
        if (null == this._currentSql || StringUtilities.isEmpty(this._currentSql.getOriginalQuery(), true)) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JTextPane textPane = new JTextPane();
        textPane.setText(this._currentSql.getOriginalQuery());
        textPane.setPreferredSize(new Dimension(this._panel.getSize().width * 2 / 3, this._panel.getSize().height * 2 / 3));
        JScrollPane scrollPane = new JScrollPane(textPane);
        popupMenu.add(scrollPane);
        popupMenu.show(this._panel.btnShowExecutingSql, 0, this._panel.btnShowExecutingSql.getHeight());
        GUIUtils.forceScrollToBegin(scrollPane);
    }

    void setStatusLabel(String text) {
        GUIUtils.processOnSwingEventThread(() -> this._panel.currentStatusLbl.setText(text));
    }

    void setQueryCount(int value) {
        this._queryCount = value;
        this._currentQueryIndex = 0;
    }

    int getTotalCount() {
        return this._queryCount;
    }

    int getCurrentQueryIndex() {
        return this._currentQueryIndex;
    }

    private void onCancel() {
        this._finishedNotificationSoundHandler.onPlayFinishedSoundChecked(false);
        this._listener.cancelRequested();
    }

    private void onClose() {
        this._panel.cancelBtn.doClick();
        this._listener.closeRquested();
    }

    CancelPanel getPanel() {
        return this._panel;
    }

    public void wasRemoved() {
        this._timer.stop();
    }

    public void setResultSetDataSetInProgress(ResultSetDataSet rsds) {
        this._timer.setResultSetDataSetInProgress(rsds);
    }
}

