/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class CurrentSqlLabelController {
    private static final Color TRANSPARENT = new Color(0xFFFFFF, true);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CurrentSqlLabelController.class);
    private String _normalizedSQL;
    private JTextPane _textPaneLabel = new JTextPane();
    private int _rowCount = -1;
    private String _rawSQL;

    public CurrentSqlLabelController() {
        this._textPaneLabel.setContentType("text/html");
        this._textPaneLabel.setEditable(false);
        this._textPaneLabel.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this._textPaneLabel.setBackground(TRANSPARENT);
        this._textPaneLabel.setOpaque(false);
        this._textPaneLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CurrentSqlLabelController.this.onMousePressedOnTextPane(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CurrentSqlLabelController.this.onMousePressedOnTextPane(e);
            }
        });
    }

    private void onMousePressedOnTextPane(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("CurrentSqlLabelController.copyRowNumber"));
        menuItem.addActionListener(ae -> this.onCopyRowNumber());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("CurrentSqlLabelController.copySelection"));
        menuItem.addActionListener(ae -> this.onCopySelection());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("CurrentSqlLabelController.copyAll"));
        menuItem.addActionListener(ae -> this.onCopyAll());
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(s_stringMgr.getString("CurrentSqlLabelController.copySQL"));
        menuItem.addActionListener(ae -> this.onCopySQL());
        popupMenu.add(menuItem);
        popupMenu.show(this._textPaneLabel, e.getX(), e.getY());
    }

    private void onCopySQL() {
        ClipboardUtil.copyToClip(this._rawSQL, true);
    }

    private void onCopyAll() {
        try {
            String htmlFreePlainText = this._textPaneLabel.getDocument().getText(0, this._textPaneLabel.getDocument().getLength());
            ClipboardUtil.copyToClip(htmlFreePlainText, true);
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void onCopySelection() {
        ClipboardUtil.copyToClip(this._textPaneLabel.getSelectedText(), true);
    }

    private void onCopyRowNumber() {
        if (-1 < this._rowCount) {
            ClipboardUtil.copyToClip("" + this._rowCount, true);
        }
    }

    public void reInit(int rowCount, boolean isResultLimitedByMaxRowsCount) {
        this.reInit(rowCount, isResultLimitedByMaxRowsCount, null, null);
    }

    public void reInit(int rowCount, boolean isResultLimitedByMaxRowsCount, String normalizedSQL, String rawSQL) {
        if (null != normalizedSQL) {
            this._normalizedSQL = normalizedSQL;
        }
        if (null != rawSQL) {
            this._rawSQL = rawSQL;
        }
        this._rowCount = rowCount;
        String escapedSql = Utilities.escapeHtmlChars(this._normalizedSQL);
        if (isResultLimitedByMaxRowsCount) {
            String limitMsg = s_stringMgr.getString("ResultTab.limitMessage", rowCount);
            this._textPaneLabel.setText("<html><pre>" + limitMsg + ";&nbsp;&nbsp;" + escapedSql + "</pre></html>");
        } else {
            String rowsMsg = s_stringMgr.getString("ResultTab.rowsMessage", rowCount);
            this._textPaneLabel.setText("<html><pre>" + rowsMsg + ";&nbsp;&nbsp;" + escapedSql + "</pre></html>");
        }
    }

    public void clear() {
        this._normalizedSQL = "";
        this._textPaneLabel.setText("");
    }

    public JTextPane getLabel() {
        return this._textPaneLabel;
    }
}

