/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.CancelStatementThread;
import net.sourceforge.squirrel_sql.client.session.StatementWrapper;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PleaseWaitDialog
extends DialogWidget {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(PleaseWaitDialog.class);
    private JButton cancelButton;
    private JButton closeButton;
    private IMessageHandler messageHandler;
    private Statement stmt;

    public PleaseWaitDialog(Statement stmt, IApplication app) {
        super(stringMgr.getString("PleaseWaitDialog.queryExecuting"), true);
        this.messageHandler = app.getMessageHandler();
        this.stmt = stmt;
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        this.setContentPane(content);
        this.pack();
    }

    private Component createMainPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(this.getTitle()), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(stringMgr.getString("PleaseWaitDialog.pleaseWait")), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0);
        ret.add((Component)this.createCancelClosePanel(), gbc);
        return ret;
    }

    private JPanel createCancelClosePanel() {
        JPanel ret = new JPanel(new GridLayout(1, 2, 5, 5));
        this.cancelButton = new JButton(stringMgr.getString("PleaseWaitDialog.cancel"));
        this.cancelButton.addActionListener(e -> this.onCancel());
        ret.add(this.cancelButton);
        this.closeButton = new JButton(stringMgr.getString("PleaseWaitDialog.close"));
        this.closeButton.addActionListener(e -> this.onClose());
        ret.add(this.closeButton);
        return ret;
    }

    private void onClose() {
        this.onCancel();
        this.setVisible(false);
        this.dispose();
    }

    private void onCancel() {
        if (this.stmt != null) {
            CancelStatementThread cst = new CancelStatementThread(new StatementWrapper(this.stmt), this.messageHandler);
            cst.tryCancel();
        }
    }

    public void showDialog(IApplication app) {
        app.getMainFrame().addWidget(this);
        this.moveToFront();
        this.setLayer(JLayeredPane.MODAL_LAYER);
        DialogWidget.centerWithinDesktop(this);
        this.setVisible(true);
    }
}

