/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class QueryInfoPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryInfoPanel.class);
    private JTextArea _queryTxt = new JTextArea();
    private JTextField _rowCountLbl = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private JTextField _executedLbl = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private JTextField _elapsedLbl = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
    private JScrollPane _queryScrollPane;

    QueryInfoPanel() {
        this.createGUI();
    }

    void load(int rowCount, SQLExecutionInfo exInfo) {
        this._queryTxt.setEditable(false);
        this._queryTxt.setText(exInfo.getQueryHolder().getOriginalQuery());
        this.displayRowCount(rowCount);
        this._executedLbl.setText(exInfo.getSQLExecutionStartTime().toString());
        this._elapsedLbl.setText(this.formatElapsedTime(exInfo));
        GUIUtils.forceScrollToBegin(this._queryScrollPane);
    }

    public void displayRowCount(int rowCount) {
        this._rowCountLbl.setText(String.valueOf(rowCount));
    }

    private String formatElapsedTime(SQLExecutionInfo exInfo) {
        NumberFormat nbrFmt = NumberFormat.getNumberInstance();
        double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
        double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
        String totalTime = nbrFmt.format(executionLength + outputLength);
        String queryTime = nbrFmt.format(executionLength);
        String outputTime = nbrFmt.format(outputLength);
        String elapsedTime = s_stringMgr.getString("ResultTab.elapsedTime", new String[]{totalTime, queryTime, outputTime});
        return elapsedTime;
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(15, 10, 0, 10), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("ResultTab.executedLabel"), 4), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 0, 0, 10), 0, 0);
        this.add((Component)this._executedLbl, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("ResultTab.rowCountLabel"), 4), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 0, 10), 0, 0);
        this.add((Component)this._rowCountLbl, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("ResultTab.statementLabel"), 4), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 10), 0, 0);
        this._queryScrollPane = new JScrollPane(this._queryTxt);
        this.add((Component)this._queryScrollPane, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 30, 10), 0, 0);
        this.add((Component)new JLabel(s_stringMgr.getString("ResultTab.elapsedTimeLabel"), 4), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 30, 10), 0, 0);
        this.add((Component)this._elapsedLbl, gbc);
    }
}

