/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ReadMoreResultsHandlerListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ReadMoreResultsHandler {
    private static final ILogger s_log = LoggerController.createLogger(ReadMoreResultsHandler.class);
    private ISession _session;
    private final JLabel _lblLoading;
    private final ImageIcon _loadingGif;
    private ExecutorService _executorService;
    private Future<SwingWorker<SwingWorker, Object>> _future;

    public ReadMoreResultsHandler(ISession session) {
        this._session = session;
        this._loadingGif = this._session.getApplication().getResources().getIcon("loading_gif");
        this._lblLoading = new JLabel(this._loadingGif);
        this._lblLoading.setVisible(false);
        this._executorService = Executors.newSingleThreadExecutor();
    }

    public void readMoreResults(final ResultSetDataSet rsds, final ReadMoreResultsHandlerListener readChannelCallBack) {
        if (null != this._future && !this._future.isDone()) {
            return;
        }
        this._lblLoading.setVisible(true);
        SwingWorker<SwingWorker, Object> sw = new SwingWorker<SwingWorker, Object>(){

            @Override
            protected SwingWorker doInBackground() {
                rsds.readMoreResults();
                return this;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    ReadMoreResultsHandler.this.onReadMoreResultsDone(readChannelCallBack);
                }
                catch (Throwable e) {
                    Main.getApplication().getMessageHandler().showErrorMessage(e);
                    s_log.error(e);
                    throw new RuntimeException(e);
                }
            }
        };
        this._future = this._executorService.submit(sw);
    }

    private void onReadMoreResultsDone(ReadMoreResultsHandlerListener readChannelCallBack) {
        try {
            this._lblLoading.setVisible(false);
            readChannelCallBack.moreResultsHaveBeenRead();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public JLabel getLoadingLabel() {
        return this._lblLoading;
    }
}

