/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

class ReloadSqlContentsHelper {
    ReloadSqlContentsHelper() {
    }

    static String getLastSqlContent(SQLAlias alias) {
        try {
            File sqlContentsFile = ReloadSqlContentsHelper.getContentsFile(alias);
            if (!sqlContentsFile.exists()) {
                return null;
            }
            FileReader fr = new FileReader(sqlContentsFile);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            StringWriter sw = new StringWriter();
            while (null != line) {
                sw.append(line).append('\n');
                line = br.readLine();
            }
            br.close();
            fr.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static File getContentsFile(SQLAlias alias) {
        File userDir = new ApplicationFiles().getUserSettingsDirectory();
        File sqlContentsDir = new File(userDir, "sqlcontents");
        sqlContentsDir.mkdirs();
        return new File(sqlContentsDir, "sqlcontents_" + StringUtilities.javaNormalize(alias.getIdentifier().toString(), false) + ".sql");
    }

    static void writeLastSqlContent(SQLAlias alias, String entireSQLScript) {
        try {
            File contentsFile = ReloadSqlContentsHelper.getContentsFile(alias);
            PrintWriter pw = new PrintWriter(contentsFile);
            pw.print(entireSQLScript);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void tryDeleteContentsFile(SQLAlias alias) {
        ReloadSqlContentsHelper.getContentsFile(alias).delete();
    }
}

