/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.ReturnResultTabAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLExecutionHandlerListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrameListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLExecutionHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColAndSumController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesChooserController;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultFrame
extends SessionDialogWidget {
    private static ILogger s_log = LoggerController.createLogger(ResultFrame.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultFrame.class);
    private ISession _session;
    private IResultTab _resultTab;
    private ResultTabFactory _resultTabFactory;
    private ResultFrameListener _resultFrameListener;
    private JButton _btnReturnToTab;
    private TabButton _btnToggleFind;
    private TabButton _btnFindColumn;
    private MarkDuplicatesChooserController _markDuplicatesChooserController;
    private JCheckBox _chkOnTop;
    private TabButton _btnReRun;
    private JPanel _centerPanel;
    private RowColAndSumController _rowColAndSumController = new RowColAndSumController();

    public ResultFrame(ISession session, IResultTab resultTab, ResultTabFactory resultTabFactory, ResultFrameListener resultFrameListener, boolean checkStayOnTop, boolean isOnRerun) {
        super(ResultFrame.getFrameTitle(session, resultTab), true, true, true, true, session);
        this._session = session;
        this._resultTab = resultTab;
        this._resultTabFactory = resultTabFactory;
        this._resultFrameListener = resultFrameListener;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        IApplication app = session.getApplication();
        this.getContentPane().add((Component)this.createTopPanel(session, app, checkStayOnTop), "North");
        this._centerPanel = new JPanel(new GridLayout(1, 1));
        this.getContentPane().add((Component)this._centerPanel, "Center");
        this._centerPanel.add(this._resultTab.getTabbedPaneOfResultTabs());
        this._resultTab.setParentWindow(this.getParentWindow());
        this._chkOnTop.addActionListener(e -> this.onStayOnTopChanged());
        this._btnReRun.addActionListener(e -> this.onRerun());
        this._btnToggleFind.addActionListener(e -> this.onFind());
        this._btnFindColumn.addActionListener(e -> this.onFindColumn());
        if (!isOnRerun) {
            this.showFrame(this, false);
        }
    }

    private void onFind() {
        this._resultTab.toggleShowFindPanel();
    }

    private void onFindColumn() {
        this._resultTab.findColumn();
    }

    private void onRerun() {
        this._btnReturnToTab.setEnabled(false);
        this._btnReRun.setEnabled(false);
        this._centerPanel.removeAll();
        new SQLExecutionHandler(this._resultTab, this._session, this._resultTab.getSqlString(), this.createSQLExecutionHandlerListener(), new ISQLExecutionListener[0]);
    }

    private ISQLExecutionHandlerListener createSQLExecutionHandlerListener() {
        return new ISQLExecutionHandlerListener(){

            @Override
            public void addResultsTab(SQLExecutionInfo info, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds, IDataSetUpdateableTableModel creator, IResultTab resultTabToReplace) {
                ResultFrame.this.onAddResultsTab(info, rsds, rsmdds, creator, resultTabToReplace);
            }

            @Override
            public void removeCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
                SwingUtilities.invokeLater(() -> ResultFrame.this.onRemoveCancelPanel(cancelPanelCtrl, resultTabToReplace));
            }

            @Override
            public void setCancelPanel(CancelPanelCtrl cancelPanelCtrl) {
                ResultFrame.this.onSetCancelPanel(cancelPanelCtrl);
            }

            @Override
            public void displayErrors(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
                ResultFrame.this.onDisplayErrors(sqlExecErrorMsgs, lastExecutedStatement);
            }
        };
    }

    private void onDisplayErrors(final ArrayList<String> sqlExecErrorMsgs, final String lastExecutedStatement) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultFrame.this._centerPanel.removeAll();
                ErrorPanel errorPanel = ResultFrame.this._resultTabFactory.createErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
                errorPanel.hideCloseButton();
                ResultFrame.this._centerPanel.add(errorPanel);
                ResultFrame.this._btnReRun.setEnabled(true);
            }
        });
    }

    private void onSetCancelPanel(final CancelPanelCtrl cancelPanelCtrl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultFrame.this._centerPanel.removeAll();
                ResultFrame.this._centerPanel.add((Component)cancelPanelCtrl.getPanel(), "Center");
            }
        });
    }

    private void onRemoveCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
        this._centerPanel.removeAll();
        cancelPanelCtrl.wasRemoved();
    }

    private void onAddResultsTab(SQLExecutionInfo info, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds, IDataSetUpdateableTableModel creator, IResultTab resultTabToReplace) {
        SwingUtilities.invokeLater(() -> this.showRerunResultsInNewFrame(info, creator, rsds, rsmdds));
    }

    private void showRerunResultsInNewFrame(SQLExecutionInfo info, IDataSetUpdateableTableModel creator, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds) {
        try {
            this._centerPanel.removeAll();
            ResultTab tab = this._resultTabFactory.createResultTab(info, creator, rsds, rsmdds);
            ResultFrame frame = new ResultFrame(this._session, tab, this._resultTabFactory, this._resultFrameListener, this._chkOnTop.isSelected(), true);
            this.showFrame(frame, true);
            this.setVisible(false);
            this.dispose();
            this._resultFrameListener.frameReplaced(this, frame);
        }
        catch (Throwable t) {
            this._session.showErrorMessage(t);
        }
    }

    private void showFrame(ResultFrame frame, boolean isOnRerun) {
        this._session.getApplication().getMainFrame().addWidget(frame);
        if (isOnRerun) {
            frame.setBounds(this.getBounds());
        } else {
            frame.pack();
            DialogWidget.centerWithinDesktop(frame);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.requestFocus();
    }

    private JPanel createTopPanel(ISession session, IApplication app, boolean checkStayOnTop) {
        JPanel ret = new JPanel(new BorderLayout(15, 0));
        JPanel pnlButtons = this.createLeftButtonsPanel(session, app, checkStayOnTop);
        ret.add((Component)pnlButtons, "West");
        ret.add((Component)new JPanel(), "Center");
        ret.add((Component)this.createRightUpperPanel(), "East");
        return ret;
    }

    private JPanel createLeftButtonsPanel(ISession session, IApplication app, boolean checkStayOnTop) {
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        this._btnReturnToTab = new JButton(new ReturnResultTabAction(app, this));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._btnReturnToTab, gbc);
        this._chkOnTop = new JCheckBox(s_stringMgr.getString("resultFrame.stayOnTop"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._chkOnTop, gbc);
        this._chkOnTop.setSelected(checkStayOnTop);
        this.initLayer();
        this._chkOnTop.setVisible(session.getApplication().getDesktopStyle().supportsLayers());
        return pnlButtons;
    }

    private JPanel createRightUpperPanel() {
        JPanel ret = new JPanel(new BorderLayout(15, 0));
        ret.add((Component)this.createRightButtonsPanel(), "East");
        this._rowColAndSumController.setDataSetViewer(this._resultTab.getSQLResultDataSetViewer());
        ret.add((Component)this._rowColAndSumController.getPanel(), "Center");
        this._rowColAndSumController.setRowColSumLayoutListener(() -> this.updateRightUpperPanelLayout(ret));
        this.updateRightUpperPanelLayout(ret);
        return ret;
    }

    public void updateRightUpperPanelLayout(JPanel panel) {
        panel.revalidate();
        if (null != panel.getParent()) {
            panel.getParent().revalidate();
        }
    }

    private JPanel createRightButtonsPanel() {
        JPanel ret = new JPanel(new GridLayout(1, 4));
        ImageIcon iconReRun = Main.getApplication().getResources().getIcon("rerun");
        this._btnReRun = new TabButton(iconReRun);
        this._btnReRun.setToolTipText(s_stringMgr.getString("ResultFrame.rerun"));
        ret.add(this._btnReRun);
        this._markDuplicatesChooserController = new MarkDuplicatesChooserController(this._resultTab);
        this._markDuplicatesChooserController.copyStateFrom(this._resultTab.getMarkDuplicatesChooserController());
        ret.add(this._markDuplicatesChooserController.getComponent());
        ImageIcon iconFindColumn = Main.getApplication().getResources().getIcon("findColumn");
        this._btnFindColumn = new TabButton(iconFindColumn);
        ret.add(this._btnFindColumn);
        ImageIcon iconFind = Main.getApplication().getResources().getIcon("find");
        this._btnToggleFind = new TabButton(iconFind);
        ret.add(this._btnToggleFind);
        return ret;
    }

    private void onStayOnTopChanged() {
        this.initLayer();
        this.toFront();
    }

    private void initLayer() {
        if (this._chkOnTop.isSelected()) {
            this.setLayer((int)JLayeredPane.PALETTE_LAYER);
        } else {
            this.setLayer((int)JLayeredPane.DEFAULT_LAYER);
        }
    }

    @Override
    public void dispose() {
        if (this._resultTab != null) {
            this._resultTab.disposeTab();
            this._resultTab = null;
        }
        super.dispose();
    }

    public void returnToTabbedPane() {
        s_log.debug("ResultFrame.returnToTabbedPane()");
        this.getContentPane().remove(this._resultTab.getTabbedPaneOfResultTabs());
        this._resultTab.returnToTabbedPane();
        this._resultTab = null;
        this.dispose();
    }

    private static String getFrameTitle(ISession session, IResultTab tab) throws IllegalArgumentException {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        return session.getTitle() + " - " + tab.getViewableSqlString();
    }

    public IResultTab getResultTab() {
        return this._resultTab;
    }

    public MarkDuplicatesChooserController getMarkDuplicatesChooserController() {
        return this._markDuplicatesChooserController;
    }
}

