/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CurrentSqlLabelController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.QueryInfoPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ReadMoreResultsHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultLabelNameSwitcher;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultSetDataSetEditsUpdater;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanelFacade;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.FindResultColumnUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.lazyresulttab.AdditionalResultTabsController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.CloseAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.CreateResultTabFrameAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.FindInResultAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.FindResultColumnAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.RerunCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColAndSumController;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ReadMoreResultsHandlerListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesChooserController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultDataSetAndCellDetailDisplayHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultTableType;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ShowCellDetailCtrl;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetViewerFindHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.makeeditable.MakeEditableToolbarCtrl;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultTab
extends JPanel
implements IHasIdentifier,
IResultTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultTab.class);
    private static ILogger s_log = LoggerController.createLogger(ResultTab.class);
    private IIdentifier _id;
    private ISession _session;
    private SQLExecutionInfo _exInfo;
    private DataSetViewerFindHandler _resultDataSetViewerFindHandler;
    private DataSetViewerFindHandler _metaDataDataSetViewerFindHandler;
    private JTabbedPane _tabResultTabs;
    private SQLResultExecuterPanelFacade _sqlResultExecuterPanelFacade;
    private CurrentSqlLabelController _currentSqlLblCtrl = new CurrentSqlLabelController();
    private String _sql;
    private QueryInfoPanel _queryInfoPanel = new QueryInfoPanel();
    private PropertyChangeListener _propsListener;
    private boolean _allowEditing;
    private IDataSetUpdateableTableModel _dataSetUpdateableTableModel;
    private ResultSetDataSet _rsds;
    private ResultTabListener _resultTabListener;
    private ReadMoreResultsHandler _readMoreResultsHandler;
    private RowColAndSumController _rowColAndSumController = new RowColAndSumController();
    private ResultLabelNameSwitcher _resultLabelNameSwitcher;
    private AdditionalResultTabsController _additionalResultTabsController;
    private MarkDuplicatesChooserController _markDuplicatesChooserController;
    private ShowCellDetailCtrl _showCellDetailCtrl;

    public ResultTab(ISession session, SQLResultExecuterPanelFacade sqlResultExecuterPanelFacade, IIdentifier id, SQLExecutionInfo exInfo, IDataSetUpdateableTableModel dataSetUpdateableTableModel, ResultTabListener resultTabListener) throws IllegalArgumentException {
        this._resultTabListener = resultTabListener;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        if (sqlResultExecuterPanelFacade == null) {
            throw new IllegalArgumentException("Null SQLPanel passed");
        }
        if (id == null) {
            throw new IllegalArgumentException("Null IIdentifier passed");
        }
        this._session = session;
        this._sqlResultExecuterPanelFacade = sqlResultExecuterPanelFacade;
        this._id = id;
        this._exInfo = exInfo;
        this.init(dataSetUpdateableTableModel);
        this._readMoreResultsHandler = new ReadMoreResultsHandler(this._session);
        this.createGUI();
        this.propertiesHaveChanged(null);
        SwingUtilities.invokeLater(() -> this._showCellDetailCtrl.finishedCreatingResultTab());
    }

    private void init(IDataSetUpdateableTableModel dataSetUpdateableTableModel) {
        IDataSetViewer resultDataSetViewer;
        this._dataSetUpdateableTableModel = dataSetUpdateableTableModel;
        this._dataSetUpdateableTableModel.addListener(new DataSetUpdateableTableModelListener(){

            @Override
            public void forceEditMode(boolean mode) {
                ResultTab.this.onForceEditMode(mode);
            }
        });
        this._allowEditing = new EditableSqlCheck(this._exInfo, this._session).allowsEditing();
        SessionProperties props = this._session.getProperties();
        if (this._allowEditing) {
            resultDataSetViewer = BaseDataSetViewerDestination.createInstance(props.getSQLResultsOutputClassName(), this._dataSetUpdateableTableModel, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._rowColAndSumController.setDataSetViewer(resultDataSetViewer);
        } else {
            resultDataSetViewer = BaseDataSetViewerDestination.createInstance(props.getReadOnlySQLResultsOutputClassName(), null, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._rowColAndSumController.setDataSetViewer(resultDataSetViewer);
        }
        this._resultDataSetViewerFindHandler = new DataSetViewerFindHandler(resultDataSetViewer, this._session, ResultTableType.SQL_QUERY_RESULT);
        if (this._session.getProperties().getShowResultsMetaData()) {
            IDataSetViewer metaDataSetViewer = BaseDataSetViewerDestination.createInstance(props.getMetaDataOutputClassName(), null, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
            this._metaDataDataSetViewerFindHandler = new DataSetViewerFindHandler(metaDataSetViewer, this._session, ResultTableType.SQL_QUERY_RESULT_META_DATA);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._propsListener == null) {
            this._propsListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ResultTab.this.propertiesHaveChanged(evt);
                }
            };
            this._session.getProperties().addPropertyChangeListener(this._propsListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
    }

    public void showResults(ResultSetDataSet rsds, ResultSetMetaDataDataSet mdds) throws DataSetException {
        this._sql = StringUtilities.cleanString(this._exInfo.getQueryHolder().getOriginalQuery());
        this._rsds = rsds;
        this._resultDataSetViewerFindHandler.getDataSetViewer().show(this._rsds, null);
        this.initContinueReadChannel();
        int rowCount = this._rsds.currentRowCount();
        this._currentSqlLblCtrl.reInit(this._rsds.currentRowCount(), this._rsds.isResultLimitedByMaxRowsCount(), this._sql, this._exInfo.getQueryHolder().getOriginalQuery());
        this._additionalResultTabsController.setCurrentResult(this._rsds);
        this._resultLabelNameSwitcher.setCurrentResult(this._rsds, this._resultDataSetViewerFindHandler.getDataSetViewer());
        if (mdds != null && this._metaDataDataSetViewerFindHandler.getDataSetViewer() != null) {
            this._metaDataDataSetViewerFindHandler.getDataSetViewer().show(mdds, null);
        }
        this._queryInfoPanel.load(rowCount, this._exInfo);
    }

    private void initContinueReadChannel() {
        final ReadMoreResultsHandlerListener readMoreResultsHandlerListener = () -> this.onMoreResultsHaveBeenRead();
        this._resultDataSetViewerFindHandler.getDataSetViewer().setContinueReadChannel(new ContinueReadChannel(){

            @Override
            public void readMoreResults() {
                ResultTab.this.onReadMoreResults(readMoreResultsHandlerListener);
            }

            @Override
            public void closeStatementAndResultSet() {
                ResultTab.this.onCloseStatementAndResultSet();
            }
        });
    }

    private void onCloseStatementAndResultSet() {
        this._rsds.closeStatementAndResultSet();
    }

    private void onReadMoreResults(ReadMoreResultsHandlerListener readMoreResultsHandlerListener) {
        if (this._rsds.isAllResultsRead()) {
            return;
        }
        this._readMoreResultsHandler.readMoreResults(this._rsds, readMoreResultsHandlerListener);
    }

    private void onMoreResultsHaveBeenRead() {
        try {
            TableState resultSortableTableState = this.getTableState(this._resultDataSetViewerFindHandler.getDataSetViewer());
            this._resultDataSetViewerFindHandler.getDataSetViewer().show(this._rsds, null);
            this.restoreTableState(resultSortableTableState, this._resultDataSetViewerFindHandler.getDataSetViewer());
            this._resultDataSetViewerFindHandler.resetFind();
            this._currentSqlLblCtrl.reInit(this._rsds.currentRowCount(), this._rsds.isResultLimitedByMaxRowsCount());
            this._queryInfoPanel.displayRowCount(this._rsds.currentRowCount());
            this._additionalResultTabsController.moreResultsHaveBeenRead();
            this._resultLabelNameSwitcher.moreResultsHaveBeenRead(this._rsds);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSqlString() {
        return this._exInfo != null ? this._exInfo.getSQL() : null;
    }

    @Override
    public String getViewableSqlString() {
        return StringUtilities.cleanString(this.getSqlString());
    }

    public String getTitle() {
        String title = this._sql;
        if (title.length() < 20) {
            return title;
        }
        return title.substring(0, 15);
    }

    @Override
    public void disposeTab() {
        if (this._metaDataDataSetViewerFindHandler != null) {
            this._metaDataDataSetViewerFindHandler.getDataSetViewer().clear();
        }
        if (this._resultDataSetViewerFindHandler != null) {
            this._resultDataSetViewerFindHandler.getDataSetViewer().clear();
        }
        this._exInfo = null;
        this._currentSqlLblCtrl.clear();
        this._sql = "";
        this._rsds.closeStatementAndResultSet();
    }

    @Override
    public void returnToTabbedPane() {
        this.add((Component)this._tabResultTabs, "Center");
        this._sqlResultExecuterPanelFacade.returnToTabbedPane(this);
        this._rowColAndSumController.setDataSetViewer(this._resultDataSetViewerFindHandler.getDataSetViewer());
        this._resultDataSetViewerFindHandler.clearParentWindow();
    }

    @Override
    public JComponent getTabbedPaneOfResultTabs() {
        return this._tabResultTabs;
    }

    @Override
    public JComponent getCompleteResultTab() {
        return this;
    }

    @Override
    public void reRunSQL() {
        this._resultTabListener.rerunSQL(this._exInfo.getSQL(), this);
    }

    private void propertiesHaveChanged(PropertyChangeEvent evt) {
        SessionProperties props = this._session.getProperties();
        if (evt == null || evt.getPropertyName().equals("sqlResultsTabPlacement")) {
            this._tabResultTabs.setTabPlacement(props.getSQLResultsTabPlacement());
        }
    }

    private void onForceEditMode(boolean editable) {
        try {
            if (editable) {
                if (this._allowEditing) {
                    TableState resultSortableTableState = this.getTableState(this._resultDataSetViewerFindHandler.getDataSetViewer());
                    IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.createInstance(SessionProperties.IDataSetDestinations.EDITABLE_TABLE, this._dataSetUpdateableTableModel, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
                    this._resultDataSetViewerFindHandler.replaceDataSetViewer(dataSetViewer);
                    this._rowColAndSumController.setDataSetViewer(this._resultDataSetViewerFindHandler.getDataSetViewer());
                    this._rsds.resetCursor();
                    this._resultDataSetViewerFindHandler.getDataSetViewer().show(this._rsds, null);
                    this.initContinueReadChannel();
                    this.restoreTableState(resultSortableTableState, this._resultDataSetViewerFindHandler.getDataSetViewer());
                } else {
                    String msg = s_stringMgr.getString("ResultTab.cannotedit");
                    JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
                }
            } else {
                SessionProperties props = this._session.getProperties();
                String readOnlyOutput = props.getReadOnlySQLResultsOutputClassName();
                TableState resultSortableTableState = this.getTableState(this._resultDataSetViewerFindHandler.getDataSetViewer());
                IDataSetViewer dataSetViewer = BaseDataSetViewerDestination.createInstance(readOnlyOutput, this._dataSetUpdateableTableModel, new DataModelImplementationDetails(this._session, this._exInfo), this._session);
                IDataSetViewer previousDataSetViewer = this._resultDataSetViewerFindHandler.replaceDataSetViewer(dataSetViewer);
                this._rowColAndSumController.setDataSetViewer(this._resultDataSetViewerFindHandler.getDataSetViewer());
                ResultSetDataSetEditsUpdater.updateEdits(previousDataSetViewer, this._rsds);
                this._rsds.resetCursor();
                this._resultDataSetViewerFindHandler.getDataSetViewer().show(this._rsds, null);
                this.initContinueReadChannel();
                this.restoreTableState(resultSortableTableState, this._resultDataSetViewerFindHandler.getDataSetViewer());
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void restoreTableState(TableState resultSortableTableState, IDataSetViewer resultSetOutput) {
        if (null != resultSortableTableState) {
            resultSetOutput.applyResultSortableTableState(resultSortableTableState);
        }
    }

    private TableState getTableState(IDataSetViewer resultSetOutput) {
        TableState resultSortableTableState = null;
        if (null != resultSetOutput) {
            resultSortableTableState = resultSetOutput.getResultSortableTableState();
        }
        return resultSortableTableState;
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        int sqlResultsTabPlacement = this._session.getProperties().getSQLResultsTabPlacement();
        this._tabResultTabs = UIFactory.getInstance().createTabbedPane(sqlResultsTabPlacement);
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this._tabResultTabs, "Center");
        this._tabResultTabs.addTab(null, this._resultDataSetViewerFindHandler.getComponent());
        this._resultLabelNameSwitcher = new ResultLabelNameSwitcher(s_stringMgr.getString("ResultTab.resultsTabTitle"), 0, this._session, this._tabResultTabs);
        if (this._session.getProperties().getShowResultsMetaData()) {
            String metadataTabTitle = s_stringMgr.getString("ResultTab.metadataTabTitle");
            this._tabResultTabs.addTab(metadataTabTitle, this._metaDataDataSetViewerFindHandler.getComponent());
        }
        String infoTabTitle = s_stringMgr.getString("ResultTab.infoTabTitle");
        this._tabResultTabs.addTab(infoTabTitle, this._queryInfoPanel);
        this._additionalResultTabsController = new AdditionalResultTabsController(this._session, this._tabResultTabs, this._resultDataSetViewerFindHandler.getDataSetViewer() instanceof DataSetViewerTablePanel);
    }

    private JPanel createTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout(15, 0));
        topPanel.add((Component)this.createTopRightPanel(), "East");
        topPanel.add((Component)this._currentSqlLblCtrl.getLabel(), "Center");
        return topPanel;
    }

    private JPanel createTopRightPanel() {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)this.createTopRightButtonsPanel(), "East");
        ret.add((Component)this._rowColAndSumController.getPanel(), "Center");
        return ret;
    }

    private JPanel createTopRightButtonsPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 5, 0, 0), 0, 0);
        ret.add((Component)this._readMoreResultsHandler.getLoadingLabel(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 10, 0, 0), 0, 0);
        ret.add((Component)new TabButton(this.getRerunCurrentSQLResultTabAction()), gbc);
        this._showCellDetailCtrl = new ShowCellDetailCtrl(this);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)this._showCellDetailCtrl.getTabButton(), gbc);
        this._markDuplicatesChooserController = new MarkDuplicatesChooserController(this);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)GUIUtils.setPreferredWidth(this._markDuplicatesChooserController.getComponent(), 42), gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)new MakeEditableToolbarCtrl(this, this._session).getTabButton(), gbc);
        gbc = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)new TabButton(new FindResultColumnAction(this)), gbc);
        gbc = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)new TabButton(new FindInResultAction(this)), gbc);
        gbc = new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 0), 0, 0);
        ret.add((Component)new TabButton(new CreateResultTabFrameAction(this)), gbc);
        gbc = new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 0, 2), 0, 0);
        ret.add((Component)new TabButton(new CloseAction(this)), gbc);
        gbc = new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private RerunCurrentSQLResultTabAction getRerunCurrentSQLResultTabAction() {
        RerunCurrentSQLResultTabAction rtn = new RerunCurrentSQLResultTabAction(this);
        rtn.setSQLPanel(this._session.getSQLPanelAPIOfActiveSessionWindow());
        return rtn;
    }

    @Override
    public void toggleShowFindPanel() {
        DataSetViewerFindHandler dataSetViewerFindHandlerOfSelectedTab = this.getDataSetViewerFindHandlerOfSelectedTabOrNull();
        if (null == dataSetViewerFindHandlerOfSelectedTab) {
            this.selectSQLResultTabSelected();
            dataSetViewerFindHandlerOfSelectedTab = this._resultDataSetViewerFindHandler;
        }
        if (!dataSetViewerFindHandlerOfSelectedTab.toggleShowFindPanel()) {
            this._session.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("ResultTab.tableSearchNotSupported"));
            s_log.warn(s_stringMgr.getString("ResultTab.tableSearchNotSupported"));
        }
    }

    @Override
    public void findColumn() {
        if (!(this._resultDataSetViewerFindHandler.getDataSetViewer() instanceof DataSetViewerTablePanel)) {
            this._session.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("ResultTab.ColumnSearchNotSupported"));
            s_log.warn(s_stringMgr.getString("ResultTab.ColumnSearchNotSupported"));
            return;
        }
        DataSetViewerTablePanel dataSetViewerTablePanel = (DataSetViewerTablePanel)this._resultDataSetViewerFindHandler.getDataSetViewer();
        this.selectSQLResultTabSelected();
        FindResultColumnUtil.findAndShowResultColumns(dataSetViewerTablePanel, GUIUtils.getOwningFrame(this._tabResultTabs));
    }

    @Override
    public void markDuplicates(ActionEvent e) {
        if (this._markDuplicatesChooserController.actionWasFired(e)) {
            this.selectSQLResultTabSelected();
        }
    }

    @Override
    public MarkDuplicatesChooserController getMarkDuplicatesChooserController() {
        return this._markDuplicatesChooserController;
    }

    public void wasReturnedToTabbedPane(MarkDuplicatesChooserController resultFramesMarkDuplicatesChooserController) {
        this._markDuplicatesChooserController.copyStateFrom(resultFramesMarkDuplicatesChooserController);
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public TableState getResultSortableTableState() {
        return this._resultDataSetViewerFindHandler.getDataSetViewer().getResultSortableTableState();
    }

    public void applyResultSortableTableState(TableState sortableTableState) {
        this._resultDataSetViewerFindHandler.getDataSetViewer().applyResultSortableTableState(sortableTableState);
    }

    @Override
    public SQLResultExecuterPanelFacade getSQLResultExecuterPanelFacade() {
        return this._sqlResultExecuterPanelFacade;
    }

    @Override
    public IDataSetViewer getSQLResultDataSetViewer() {
        return this._resultDataSetViewerFindHandler.getDataSetViewer();
    }

    @Override
    public void setParentWindow(Window parent) {
        if (null != this.getDataSetViewerFindHandlerOfSelectedTabOrNull()) {
            this.getDataSetViewerFindHandlerOfSelectedTabOrNull().setParentWindow(parent);
        }
    }

    private DataSetViewerFindHandler getDataSetViewerFindHandlerOfSelectedTabOrNull() {
        if (0 == this._tabResultTabs.getSelectedIndex()) {
            return this._resultDataSetViewerFindHandler;
        }
        if (1 == this._tabResultTabs.getSelectedIndex() && null != this._metaDataDataSetViewerFindHandler) {
            return this._metaDataDataSetViewerFindHandler;
        }
        return this._additionalResultTabsController.getDataSetViewerFindHandlerOfSelectedTabOrNull();
    }

    public boolean allowsEditing() {
        return this._allowEditing;
    }

    @Override
    public boolean isSQLResultTabSelected() {
        return 0 == this._tabResultTabs.getSelectedIndex();
    }

    @Override
    public ResultDataSetAndCellDetailDisplayHandler getSelectedResultTabsDisplayHandler() {
        DataSetViewerFindHandler findHandler = this.getDataSetViewerFindHandlerOfSelectedTabOrNull();
        if (null == findHandler) {
            return null;
        }
        return findHandler.getResultDisplayHandler();
    }

    public void selectSQLResultTabSelected() {
        this._tabResultTabs.setSelectedIndex(0);
    }
}

