/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlHistoryListener;

public class SQLHistory {
    private List<SQLHistoryItem> _history = new ArrayList<SQLHistoryItem>();
    private List<SqlHistoryListener> _sqlHistoryListeners = new ArrayList<SqlHistoryListener>();

    public SQLHistoryItem[] getSQLHistoryItems() {
        SQLHistoryItem[] data = new SQLHistoryItem[this._history.size()];
        return this._history.toArray(data);
    }

    public void setSQLHistoryItems(SQLHistoryItem[] data) {
        this._history.clear();
        Arrays.sort(data, Comparator.comparing(SQLHistoryItem::getLastUsageTime, Comparator.nullsLast(Comparator.reverseOrder())));
        this._history.addAll(Arrays.asList(data));
    }

    public void addSQLHistoryItem(SQLHistoryItem sqlHistoryItem) {
        if (sqlHistoryItem == null) {
            throw new IllegalArgumentException("SQLHistoryItem == null");
        }
        while (this._history.remove(sqlHistoryItem)) {
        }
        this._history.add(0, sqlHistoryItem);
        new ArrayList<SqlHistoryListener>(this._sqlHistoryListeners).forEach(l -> l.newSqlHistoryItem(sqlHistoryItem));
    }

    public void addSQLHistoryListener(SqlHistoryListener sqlHistoryListener) {
        this._sqlHistoryListeners.add(sqlHistoryListener);
    }

    public void removeSQLHistoryListener(SqlHistoryListener sqlHistoryListener) {
        this._sqlHistoryListeners.remove(sqlHistoryListener);
    }
}

