/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.OpenSqlHistoryAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLResultExecuterTabListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecutor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ReloadSqlContentsHelper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryComboBox;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryComboBoxModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelListenerManager;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelSplitPaneFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecutorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SessionStartupMainSQLTabContentLoader;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SetSessionAutoCommitTask;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlListenerService;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ToggleResultMinimizeHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.UndoHandlerImpl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTracker;
import net.sourceforge.squirrel_sql.client.session.mainpanel.multiclipboard.PasteFromHistoryAttach;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.SQLPanelSplitter;
import net.sourceforge.squirrel_sql.client.session.properties.ResultLimitAndReadOnPanelSmallPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLPanel
extends JPanel {
    private static final ILogger s_log = LoggerController.createLogger(SQLPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPanel.class);
    private static final String LINE_SEPARATOR = "\n";
    private static boolean s_loadedSQLHistory;
    private SqlListenerService _sqlListenerService;
    private final SQLPanelSplitter _sqlPanelSplitter;
    private transient ISession _session;
    private SQLHistoryComboBox _sqlHistoryComboBox;
    private ISQLEntryPanel _sqlEntry;
    private SqlComboListener _sqlComboListener = new SqlComboListener();
    private MyPropertiesListener _propsListener;
    private SQLPanelListenerManager _sqlPanelListenerManager = new SQLPanelListenerManager();
    private JPanel _executerPanleHolder;
    private JTabbedPane _tabbedExecuterPanel;
    private JPanel _simpleExecuterPanel;
    private boolean _hasBeenVisible = false;
    private JSplitPane _splitPane;
    private final List<ISQLResultExecutor> _executors = new ArrayList<ISQLResultExecutor>();
    private SQLResultExecutorPanel _sqlExecPanel;
    private ISQLPanelAPI _panelAPI;
    private UndoHandlerImpl _undoHandler;
    private ResultLimitAndReadOnPanelSmallPanel _resultLimitAndReadOnPanelSmallPanel = new ResultLimitAndReadOnPanelSmallPanel();
    private ToggleResultMinimizeHandler _toggleResultMinimizeHandler;
    private SQLPanelPosition _sqlPanelPosition;
    private ChangeTracker _changeTracker;

    public SQLPanel(ISession session, SQLPanelPosition sqlPanelPosition, TitleFilePathHandler titleFileHandler) {
        this._sqlPanelPosition = sqlPanelPosition;
        this.setSession(session);
        this.createGUI();
        this.propertiesHaveChanged(null);
        this._sqlExecPanel = new SQLResultExecutorPanel(session, true);
        this._sqlListenerService = new SqlListenerService(session, sqlHistItem -> this.addSQLToHistoryComboBox(sqlHistItem));
        this._sqlListenerService.getSqlExecutionListeners().forEach(l -> this._sqlExecPanel.addSQLExecutionListener((ISQLExecutionListener)l));
        this.addExecutor(this._sqlExecPanel);
        this._panelAPI = new SQLPanelAPI(this, titleFileHandler);
        this._changeTracker.initChangeTracking(this._panelAPI);
        this._resultLimitAndReadOnPanelSmallPanel.loadData(session.getProperties());
        this._toggleResultMinimizeHandler = new ToggleResultMinimizeHandler(this._splitPane);
        if (SQLPanelPosition.MAIN_TAB_IN_SESSION_WINDOW == this._sqlPanelPosition) {
            SessionStartupMainSQLTabContentLoader.handleLoadFileAtSessionStart(session, this._panelAPI);
        }
        this._sqlPanelSplitter = new SQLPanelSplitter(this);
    }

    public SQLPanelSplitter getSqlPanelSplitter() {
        return this._sqlPanelSplitter;
    }

    public synchronized void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this.sessionClosing();
        this._session = session;
        if (null == this._propsListener) {
            this._propsListener = new MyPropertiesListener();
        } else {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
        }
        this._session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public ISQLPanelAPI getSQLPanelAPI() {
        return this._panelAPI;
    }

    public synchronized ISession getSession() {
        return this._session;
    }

    public void addExecutor(ISQLResultExecutor exec) {
        this._executors.add(exec);
        if (1 == this._executors.size()) {
            this._executerPanleHolder.remove(this._tabbedExecuterPanel);
            this._executerPanleHolder.add(this._simpleExecuterPanel);
        } else if (2 == this._executors.size()) {
            this._executerPanleHolder.remove(this._simpleExecuterPanel);
            this._executerPanleHolder.add(this._tabbedExecuterPanel);
            this._executors.get(0);
            ISQLResultExecutor buf = this._executors.get(0);
            this._tabbedExecuterPanel.addTab(buf.getTitle(), null, buf.getComponent(), buf.getTitle());
        }
        if (1 < this._executors.size()) {
            this._tabbedExecuterPanel.addTab(exec.getTitle(), null, exec.getComponent(), exec.getTitle());
        } else {
            this._simpleExecuterPanel.add(exec.getComponent());
        }
        this._sqlPanelListenerManager.fireExecuterTabAdded(exec);
    }

    public void removeExecutor(ISQLResultExecutor exec) {
        this._executors.remove(exec);
    }

    public SQLResultExecutorPanel getSQLExecPanel() {
        return this._sqlExecPanel;
    }

    public ChangeTracker getChangeTracker() {
        return this._changeTracker;
    }

    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._sqlExecPanel.addSQLExecutionListener(lis);
    }

    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._sqlExecPanel.removeSQLExecutionListener(lis);
    }

    public void addSQLPanelListener(ISQLPanelListener lis) {
        this._sqlPanelListenerManager.addSQLPanelListener(lis);
    }

    public void removeSQLPanelListener(ISQLPanelListener lis) {
        this._sqlPanelListenerManager.removeSQLPanelListener(lis);
    }

    public void addExecuterTabListener(ISQLResultExecuterTabListener lis) {
        this._sqlPanelListenerManager.addExecuterTabListener(lis);
    }

    public synchronized void removeExecuterTabListener(ISQLResultExecuterTabListener lis) {
        this._sqlPanelListenerManager.removeExecuterTabListener(lis);
    }

    public ISQLEntryPanel getSQLEntryPanel() {
        return this._sqlEntry;
    }

    public void runCurrentExecuter() {
        this._runExecuter(ISQLResultExecutor.ExecutionScope.EXEC_CURRENT_SQL);
    }

    public void runAllSqlsExecuter() {
        this._runExecuter(ISQLResultExecutor.ExecutionScope.EXEC_ALL_SQLS);
    }

    private void _runExecuter(ISQLResultExecutor.ExecutionScope executionScope) {
        if (1 == this._executors.size()) {
            ISQLResultExecutor exec = this._executors.get(0);
            exec.execute(this._sqlEntry, executionScope);
        } else {
            int selectedIndex = this._tabbedExecuterPanel.getSelectedIndex();
            ISQLResultExecutor exec = this._executors.get(selectedIndex);
            exec.execute(this._sqlEntry, executionScope);
        }
    }

    public void sessionClosing() {
        if (this._propsListener == null) {
            return;
        }
        this._session.getProperties().removePropertyChangeListener(this._propsListener);
        this._propsListener = null;
        if (Main.getApplication().getSquirrelPreferences().isReloadSqlContents()) {
            if (SQLPanelPosition.MAIN_TAB_IN_SESSION_WINDOW == this._sqlPanelPosition) {
                String entireSQLScript = this._panelAPI.getEntireSQLScript();
                if (StringUtilities.isEmpty(entireSQLScript, true)) {
                    ReloadSqlContentsHelper.tryDeleteContentsFile(this.getSession().getAlias());
                } else {
                    ReloadSqlContentsHelper.writeLastSqlContent(this.getSession().getAlias(), entireSQLScript);
                }
            }
        } else {
            ReloadSqlContentsHelper.tryDeleteContentsFile(this.getSession().getAlias());
        }
    }

    public void sessionWorksheetOrTabClosing() {
        this._sqlPanelListenerManager.fireSQLEntryAreaClosed();
        this._sqlPanelSplitter.sessionWindowClosing();
        if (this._hasBeenVisible) {
            SQLPanelSplitPaneFactory.saveOrientationDependingDividerLocation(this._splitPane);
        }
        this._sqlHistoryComboBox.removeActionListener(this._sqlComboListener);
        this._sqlHistoryComboBox.dispose();
        this._sqlListenerService.getSqlExecutionListeners().forEach(l -> this._sqlExecPanel.removeSQLExecutionListener((ISQLExecutionListener)l));
        this._sqlListenerService.close();
        this._changeTracker.close();
        this._sqlPanelListenerManager.fireSQLPanelParentClosing();
    }

    private void installSQLEntryPanel(ISQLEntryPanel pnl) {
        if (pnl == null) {
            throw new IllegalArgumentException("Null ISQLEntryPanel passed");
        }
        this._sqlEntry = pnl;
        int pos = this._splitPane.getDividerLocation();
        this._changeTracker = new ChangeTracker(this._sqlEntry);
        this._splitPane.add((Component)this._changeTracker.embedInTracking(), "left");
        this._splitPane.setDividerLocation(pos);
        this._undoHandler = new UndoHandlerImpl(this._sqlEntry);
        new PasteFromHistoryAttach(this._sqlEntry);
        this._sqlPanelListenerManager.fireSQLEntryAreaInstalled();
    }

    public void storeSplitPanePositionOnSessionClose(boolean value) {
        super.setVisible(value);
        if (value) {
            this._hasBeenVisible = true;
        }
    }

    private void addSQLToHistoryComboBox(SQLHistoryItem sql) {
        if (sql == null) {
            throw new IllegalArgumentException("SQLHistoryItem == null");
        }
        this._sqlComboListener.stopListening();
        try {
            this._sqlHistoryComboBox.removeItem(sql);
            this._sqlHistoryComboBox.insertItemAt(sql, 0);
            this._sqlHistoryComboBox.setSelectedIndex(0);
            this._sqlHistoryComboBox.repaint();
        }
        finally {
            this._sqlComboListener.startListening();
        }
    }

    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this.getSQLEntryPanel().addToSQLEntryAreaMenu(menu);
    }

    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this.getSQLEntryPanel().addToSQLEntryAreaMenu(action);
    }

    public void addSeparatorToSQLEntryAreaMenu() {
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
    }

    private void appendSQL(String sql) {
        if (this._sqlEntry.getText().length() > 0) {
            this._sqlEntry.appendText("\n\n");
        }
        this._sqlEntry.appendText(sql, true);
        this._sqlEntry.requestFocus();
    }

    private void copySelectedItemToEntryArea() {
        SQLHistoryItem item = (SQLHistoryItem)this._sqlHistoryComboBox.getSelectedItem();
        if (item != null) {
            this.appendSQL(item.getSQL());
        }
    }

    private void openSQLHistory() {
        new SQLHistoryController(this._session, this.getSQLPanelAPI(), ((SQLHistoryComboBoxModel)this._sqlHistoryComboBox.getModel()).getItems());
    }

    private void propertiesHaveChanged(String propName) {
        FontInfo fi;
        SessionProperties props = this._session.getProperties();
        if (propName == null || propName.equals("sqlShareHistory")) {
            this._sqlHistoryComboBox.setUseSharedModel(props.getSQLShareHistory());
        }
        if (propName == null || propName.equals("autoCommit")) {
            SetSessionAutoCommitTask task = new SetSessionAutoCommitTask(this._session);
            if (SwingUtilities.isEventDispatchThread()) {
                this._session.getApplication().getThreadPool().addTask(task);
            } else {
                task.run();
            }
        }
        if (propName == null || propName.equals("sqlLimitRows")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlNbrOfRowsToShow")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlReadOn")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlReadOnBlockSize")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if ((propName == null || propName.equals("fontInfo")) && (fi = props.getFontInfo()) != null) {
            this._sqlEntry.setFont(fi.createFont());
        }
        if (propName == null || propName.equals("sqlEntryHistorySize") || propName.equals("limitSqlEntryHistorySize")) {
            if (props.getLimitSQLEntryHistorySize()) {
                this._sqlHistoryComboBox.setMaxMemoryCount(props.getSQLEntryHistorySize());
            } else {
                this._sqlHistoryComboBox.setMaxMemoryCount(-1);
            }
        }
    }

    public ArrayList<SQLHistoryItem> getSQLHistoryItems() {
        return ((SQLHistoryComboBoxModel)this._sqlHistoryComboBox.getModel()).getItems();
    }

    public void toggleMinimizeResults() {
        this._toggleResultMinimizeHandler.toggleMinimizeResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGUI() {
        IApplication app = this._session.getApplication();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!s_loadedSQLHistory) {
                SQLHistory sqlHistory = app.getSQLHistory();
                SQLHistoryComboBoxModel.initializeSharedInstance(sqlHistory.getSQLHistoryItems());
                s_loadedSQLHistory = true;
            }
        }
        this._tabbedExecuterPanel = UIFactory.getInstance().createTabbedPane();
        this._tabbedExecuterPanel.addChangeListener(new MyExecuterPaneListener());
        this.setLayout(new BorderLayout());
        SessionProperties props = this._session.getProperties();
        this._sqlHistoryComboBox = new SQLHistoryComboBox(props.getSQLShareHistory());
        this._sqlHistoryComboBox.setEditable(false);
        if (this._sqlHistoryComboBox.getItemCount() > 0) {
            this._sqlHistoryComboBox.setSelectedIndex(0);
        }
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this._sqlHistoryComboBox, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new CopyLastButton(app));
        box.add(new ShowHistoryButton(app));
        box.add(Box.createHorizontalStrut(10));
        box.add(this._resultLimitAndReadOnPanelSmallPanel);
        pnl.add((Component)box, "East");
        this.add((Component)pnl, "North");
        this._splitPane = SQLPanelSplitPaneFactory.createSplitPane(this.getSession());
        this._splitPane.setOneTouchExpandable(true);
        this.installSQLEntryPanel(app.getSQLEntryPanelFactory().createSQLEntryPanel(this._session, new HashMap<String, Object>()));
        this._executerPanleHolder = new JPanel(new GridLayout(1, 1));
        this._executerPanleHolder.setMinimumSize(new Dimension(50, 50));
        this._simpleExecuterPanel = new JPanel(new GridLayout(1, 1));
        this._executerPanleHolder.add(this._simpleExecuterPanel);
        this._splitPane.add((Component)this._executerPanleHolder, "right");
        this.add((Component)this._splitPane, "Center");
        this._sqlHistoryComboBox.addActionListener(this._sqlComboListener);
        SwingUtilities.invokeLater(() -> this._sqlEntry.getTextComponent().requestFocus());
    }

    public Action getUndoAction() {
        return this._undoHandler.getUndoAction();
    }

    public Action getRedoAction() {
        return this._undoHandler.getRedoAction();
    }

    public UndoHandlerImpl getUndoHandlerImpl() {
        return this._undoHandler;
    }

    public SQLPanelPosition getSQLPanelPosition() {
        return this._sqlPanelPosition;
    }

    private class ShowHistoryButton
    extends JButton {
        ShowHistoryButton(IApplication app) {
            SquirrelResources rsrc = app.getResources();
            ImageIcon icon = rsrc.getIcon("SQLHistory");
            this.setIcon(icon);
            String hint = s_stringMgr.getString("SQLPanel.openSqlHistory.hint");
            this.setToolTipText(hint);
            Dimension dm = this.getPreferredSize();
            dm.setSize(dm.height, dm.height);
            this.setPreferredSize(dm);
            this.addActionListener(SQLPanel.this._session.getApplication().getActionCollection().get(OpenSqlHistoryAction.class));
        }
    }

    private class CopyLastButton
    extends JButton {
        CopyLastButton(IApplication app) {
            SquirrelResources rsrc = app.getResources();
            ImageIcon icon = rsrc.getIcon("CopySelected");
            this.setIcon(icon);
            String hint = s_stringMgr.getString("SQLPanel.copylastbutton.hint");
            this.setToolTipText(hint);
            Dimension dm = this.getPreferredSize();
            dm.setSize(dm.height, dm.height);
            this.setPreferredSize(dm);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLPanel.this.copySelectedItemToEntryArea();
                }
            });
        }
    }

    private class SqlComboListener
    implements ActionListener {
        private boolean _listening = true;

        private SqlComboListener() {
        }

        void stopListening() {
            this._listening = false;
        }

        void startListening() {
            this._listening = true;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this._listening) {
                SQLPanel.this.copySelectedItemToEntryArea();
            }
        }
    }

    private class MyPropertiesListener
    implements PropertyChangeListener {
        private MyPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SQLPanel.this.propertiesHaveChanged(evt.getPropertyName());
        }
    }

    private class MyExecuterPaneListener
    implements ChangeListener {
        private MyExecuterPaneListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int index = pane.getSelectedIndex();
            if (index != -1) {
                SQLPanel.this._sqlPanelListenerManager.fireExecuterTabActivated(SQLPanel.this._executors.get(index));
            }
        }
    }
}

