/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLResultExecuterTabListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLPanelEvent;
import net.sourceforge.squirrel_sql.client.session.event.SQLResultExecuterTabEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecutor;

public class SQLPanelListenerManager {
    private List<ISQLPanelListener> _sqlPanelListener = new ArrayList<ISQLPanelListener>();
    private List<ISQLResultExecuterTabListener> _sqlResultExecuterTabListener = new ArrayList<ISQLResultExecuterTabListener>();

    public synchronized void addSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLPanelListener passed");
        }
        this._sqlPanelListener.add(lis);
    }

    public synchronized void removeSQLPanelListener(ISQLPanelListener lis) {
        this._sqlPanelListener.remove(lis);
    }

    public void addExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._sqlResultExecuterTabListener.add(lis);
    }

    public synchronized void removeExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._sqlResultExecuterTabListener.remove(lis);
    }

    public void fireSQLEntryAreaInstalled() {
        SQLPanelEvent evt = new SQLPanelEvent();
        for (ISQLPanelListener isqlPanelListener : this._sqlPanelListener.toArray(new ISQLPanelListener[0])) {
            isqlPanelListener.sqlEntryAreaInstalled(evt);
        }
    }

    public void fireSQLEntryAreaClosed() {
        SQLPanelEvent evt = new SQLPanelEvent();
        for (ISQLPanelListener isqlPanelListener : this._sqlPanelListener.toArray(new ISQLPanelListener[0])) {
            isqlPanelListener.sqlEntryAreaClosed(evt);
        }
    }

    public void fireExecuterTabAdded(ISQLResultExecutor exec) {
        SQLResultExecuterTabEvent evt = new SQLResultExecuterTabEvent(exec);
        for (ISQLResultExecuterTabListener isqlResultExecuterTabListener : this._sqlResultExecuterTabListener.toArray(new ISQLResultExecuterTabListener[0])) {
            isqlResultExecuterTabListener.executerTabAdded(evt);
        }
    }

    public void fireExecuterTabActivated(ISQLResultExecutor exec) {
        SQLResultExecuterTabEvent evt = new SQLResultExecuterTabEvent(exec);
        for (ISQLResultExecuterTabListener isqlResultExecuterTabListener : this._sqlResultExecuterTabListener.toArray(new ISQLResultExecuterTabListener[0])) {
            isqlResultExecuterTabListener.executerTabActivated(evt);
        }
    }

    public void fireSQLPanelParentClosing() {
        for (ISQLPanelListener isqlPanelListener : this._sqlPanelListener) {
            isqlPanelListener.panelParentClosing();
        }
    }
}

