/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class SQLPanelSplitPaneFactory {
    private static final String PREFS_KEY_SPLIT_DIVIDER_LOC = "squirrelSql_sqlPanel_divider_loc";
    private static final String PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL = "squirrelSql_sqlPanel_divider_loc_horizontal";

    static void saveOrientationDependingDividerLocation(JSplitPane splitPane) {
        int dividerLoc = splitPane.getDividerLocation();
        if (splitPane.getOrientation() == 0) {
            Props.putInt(PREFS_KEY_SPLIT_DIVIDER_LOC, dividerLoc);
        } else {
            Props.putInt(PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL, dividerLoc);
        }
    }

    static JSplitPane createSplitPane(ISession session) {
        int spOrientation = session.getProperties().getSqlPanelOrientation();
        final JSplitPane splitPane = new JSplitPane(spOrientation);
        int dividerLoc = SQLPanelSplitPaneFactory.calculateDividerLocation(spOrientation, false, splitPane);
        splitPane.setDividerLocation(dividerLoc);
        session.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("sqlPanelOrientation".equals(evt.getPropertyName())) {
                    SQLPanelSplitPaneFactory.saveOrientationDependingDividerLocation(splitPane);
                    splitPane.setOrientation((Integer)evt.getNewValue());
                    splitPane.setDividerLocation(SQLPanelSplitPaneFactory.calculateDividerLocation(splitPane.getOrientation(), false, splitPane));
                    splitPane.repaint();
                }
            }
        });
        SplitPaneUI spUI = splitPane.getUI();
        if (spUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI bspUI = (BasicSplitPaneUI)spUI;
            bspUI.getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        splitPane.setDividerLocation(SQLPanelSplitPaneFactory.calculateDividerLocation(splitPane.getOrientation(), true, splitPane));
                    }
                }
            });
        }
        return splitPane;
    }

    static int calculateDividerLocation(int orientation, boolean useDefault, JSplitPane splitPane) {
        int dividerLoc;
        Dimension parentDim = splitPane.getSize();
        if (orientation == 0) {
            int def = parentDim.height - 200;
            dividerLoc = !useDefault ? Props.getInt(PREFS_KEY_SPLIT_DIVIDER_LOC, def) : def;
        } else {
            int def = parentDim.width / 2;
            dividerLoc = !useDefault ? Props.getInt(PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL, def) : def;
        }
        return dividerLoc;
    }
}

