/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToLeftAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsToRightAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabAnchoredAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLExecutionHandlerListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecutor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrameListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabClosing;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLExecutionHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanelFacade;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SetSessionAutoCommitTask;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabIconManager;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabbedExcutionPanelUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.custompanel.CustomResultPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesChooserController;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.ButtonTabComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLResultExecutorPanel
extends JPanel
implements ISQLResultExecutor {
    private static final ILogger s_log = LoggerController.createLogger(SQLResultExecutorPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLResultExecutorPanel.class);
    private ISession _session;
    private JTabbedPane _tabbedExecutionsPanel;
    private ArrayList<ResultFrame> _sqlResultFrames = new ArrayList();
    private ArrayList<ISQLExecutionListener> _sqlExecutionListeners = new ArrayList();
    private ResultTabFactory _resultTabFactory;
    private IResultTab _stickyTab;
    private TabIconManager _tabIconManager = new TabIconManager();
    private final ResultTabClosing _resultTabClosing;

    public JTabbedPane getTabbedPane() {
        return this._tabbedExecutionsPanel;
    }

    public SQLResultExecutorPanel(ISession session) {
        this(session, false);
    }

    public SQLResultExecutorPanel(ISession session, boolean processSessionPropertyChanges) {
        this._resultTabFactory = new ResultTabFactory(session, this.createSQLResultExecuterPanelFacade());
        this._session = session;
        if (processSessionPropertyChanges) {
            this._session.getProperties().addPropertyChangeListener(evt -> this.propertiesHaveChanged(evt.getPropertyName()));
        }
        this.createGUI();
        if (processSessionPropertyChanges) {
            this.propertiesHaveChanged(null);
        }
        this._resultTabClosing = new ResultTabClosing(this._tabIconManager, this._tabbedExecutionsPanel);
    }

    private SQLResultExecuterPanelFacade createSQLResultExecuterPanelFacade() {
        return new SQLResultExecuterPanelFacade(){

            @Override
            public void closeResultTab(IResultTab resultTab) {
                SQLResultExecutorPanel.this._resultTabClosing.closeTab(resultTab.getCompleteResultTab());
            }

            @Override
            public void returnToTabbedPane(ResultTab resultTab) {
                SQLResultExecutorPanel.this.returnToTabbedPane(resultTab);
            }

            @Override
            public void createSQLResultFrame(IResultTab resultTab) {
                SQLResultExecutorPanel.this.createSQLResultFrame(resultTab);
            }

            @Override
            public void rerunSQL(String sql, IResultTab resultTab) {
                SQLResultExecutorPanel.this.rerunSQL(sql, resultTab);
            }

            @Override
            public void removeErrorPanel(ErrorPanel errorPanel) {
                SQLResultExecutorPanel.this.removeErrorPanel(errorPanel);
            }
        };
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("SQLResultExecuterPanel.title");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public ISession getSession() {
        return this._session;
    }

    public void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._sqlExecutionListeners.add(lis);
    }

    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._sqlExecutionListeners.remove(lis);
    }

    @Override
    public void execute(ISQLEntryPanel sqlPanel, ISQLResultExecutor.ExecutionScope executionScope) {
        this.removeErrorPanels();
        String sql = ISQLResultExecutor.ExecutionScope.EXEC_CURRENT_SQL == executionScope ? sqlPanel.getSQLToBeExecuted() : sqlPanel.getText();
        if (sql != null && sql.length() > 0) {
            this.executeSQL(sql);
        } else {
            String msg = s_stringMgr.getString("SQLResultExecuterPanel.nosqlselected");
            this._session.showErrorMessage(msg);
        }
    }

    private void removeErrorPanels() {
        ArrayList<ErrorPanel> toRemove = new ArrayList<ErrorPanel>();
        for (int i = 0; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
            Component tab = this._tabbedExecutionsPanel.getComponentAt(i);
            if (!(tab instanceof ErrorPanel)) continue;
            toRemove.add((ErrorPanel)tab);
        }
        for (ErrorPanel errorPanel : toRemove) {
            this._resultTabClosing.closeTab(errorPanel);
        }
    }

    public void executeSQL(String sql) {
        this.executeSQL(sql, null);
    }

    public void executeSQL(String sql, String tableToBeEdited) {
        if (sql != null && sql.trim().length() > 0) {
            this.removeErrorPanels();
            String origSQL = sql;
            sql = this.fireSQLToBeExecutedEvent(sql);
            if (sql == null) {
                s_log.info("executeSQL: An ISQLExecutionListener veto'd execution of the following SQL: " + origSQL);
                return;
            }
            ISQLExecutionListener[] executionListeners = this._sqlExecutionListeners.toArray(new ISQLExecutionListener[0]);
            new SQLExecutionHandler(null, this._session, sql, this.createSQLExecutionHandlerListener(), executionListeners, tableToBeEdited);
        }
    }

    private ISQLExecutionHandlerListener createSQLExecutionHandlerListener() {
        return new ISQLExecutionHandlerListener(){

            @Override
            public void addResultsTab(SQLExecutionInfo info, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds, IDataSetUpdateableTableModel dataSetUpdateableTableModel, IResultTab resultTabToReplace) {
                SwingUtilities.invokeLater(() -> SQLResultExecutorPanel.this.onAddResultsTab(info, rsds, rsmdds, dataSetUpdateableTableModel, resultTabToReplace));
            }

            @Override
            public void removeCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
                SwingUtilities.invokeLater(() -> SQLResultExecutorPanel.this.onRemoveCancelPanel(cancelPanelCtrl, resultTabToReplace));
            }

            @Override
            public void setCancelPanel(CancelPanelCtrl cancelPanelCtrl) {
                SQLResultExecutorPanel.this.onSetCancelPanel(cancelPanelCtrl);
            }

            @Override
            public void displayErrors(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
                SQLResultExecutorPanel.this.onDisplayErrors(sqlExecErrorMsgs, lastExecutedStatement);
            }
        };
    }

    private void onDisplayErrors(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        Runnable runnable = () -> this.showErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
        SwingUtilities.invokeLater(runnable);
    }

    private void showErrorPanel(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        ErrorPanel errorPanel = this._resultTabFactory.createErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
        this._tabbedExecutionsPanel.add(s_stringMgr.getString("SQLResultExecuterPanel.ErrorTabHeader"), errorPanel);
        this._tabbedExecutionsPanel.setSelectedComponent(errorPanel);
    }

    private void removeErrorPanel(ErrorPanel errorPanel) {
        this._tabbedExecutionsPanel.remove(errorPanel);
    }

    private void rerunSQL(String sql, IResultTab resultTabToReplace) {
        new SQLExecutionHandler(resultTabToReplace, this._session, sql, this.createSQLExecutionHandlerListener(), new ISQLExecutionListener[0]);
    }

    public void closeAllSQLResultFrames() {
        for (ResultFrame sqlResultFrame : this._sqlResultFrames) {
            sqlResultFrame.dispose();
        }
    }

    public void closeAllSQLResultTabs() {
        this.closeAllSQLResultTabs(false);
    }

    public void closeAllSQLResultTabs(boolean isMemoryCleanUp) {
        ArrayList<JComponent> allTabs = this.getAllTabs();
        this._resultTabClosing.closeTabs(allTabs, isMemoryCleanUp);
    }

    private ArrayList<JComponent> getAllTabs() {
        ArrayList<JComponent> allTabs = new ArrayList<JComponent>();
        for (int i = 0; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
            JComponent component = (JComponent)this._tabbedExecutionsPanel.getComponentAt(i);
            if (component instanceof CancelPanel) continue;
            allTabs.add(component);
        }
        return allTabs;
    }

    public void closeAllButCurrentResultTabs() {
        Component selectedTab = this._tabbedExecutionsPanel.getSelectedComponent();
        ArrayList<JComponent> allTabs = this.getAllTabs();
        ArrayList<JComponent> allButCurrent = new ArrayList<JComponent>(allTabs);
        allButCurrent.remove(selectedTab);
        this._resultTabClosing.closeTabs(allButCurrent);
    }

    public boolean confirmClose() {
        return this._resultTabClosing.confirmSqlPanelClose(this.getAllTabs());
    }

    public void closeAllToResultTabs(boolean left) {
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ArrayList<JComponent> tabsToClose = new ArrayList<JComponent>();
        if (left) {
            for (int i = 0; i < selectedIndex; ++i) {
                tabsToClose.add((JComponent)this._tabbedExecutionsPanel.getComponentAt(i));
            }
        } else {
            for (int i = selectedIndex + 1; i < this._tabbedExecutionsPanel.getTabCount(); ++i) {
                tabsToClose.add((JComponent)this._tabbedExecutionsPanel.getComponentAt(i));
            }
        }
        this._resultTabClosing.closeTabs(tabsToClose);
    }

    public void toggleCurrentSQLResultTabSticky() {
        if (null != this._stickyTab) {
            if (this._stickyTab.equals(this._tabbedExecutionsPanel.getSelectedComponent())) {
                this._stickyTab = null;
                this.setIconAt(this._tabbedExecutionsPanel.getSelectedIndex(), null);
                return;
            }
            int indexOfStickyTab = TabbedExcutionPanelUtil.getIndexOfTab(this._stickyTab, this._tabbedExecutionsPanel);
            if (-1 != indexOfStickyTab) {
                this.setIconAt(indexOfStickyTab, null);
            }
            this._stickyTab = null;
        }
        if (!(this._tabbedExecutionsPanel.getSelectedComponent() instanceof IResultTab)) {
            if (null != this._tabbedExecutionsPanel.getSelectedComponent()) {
                String msg = s_stringMgr.getString("SQLResultExecuterPanel.nonStickyPanel");
                JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
            }
            return;
        }
        this._stickyTab = (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ImageIcon icon = this._tabIconManager.getStickyIcon();
        this.setIconAt(selectedIndex, icon);
    }

    public void toggleCurrentSQLResultTabAnchored() {
        int selectedIndex;
        if (null != this._stickyTab && this._stickyTab.equals(this._tabbedExecutionsPanel.getSelectedComponent())) {
            this._stickyTab = null;
        }
        if (-1 == (selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex())) {
            return;
        }
        if (this._resultTabClosing.isAnchoredAt(selectedIndex)) {
            this.setIconAt(selectedIndex, null);
        } else {
            this.setIconAt(selectedIndex, this._tabIconManager.getAnchorIcon());
        }
    }

    private void setIconAt(int index, ImageIcon icon) {
        ((JLabel)this._tabbedExecutionsPanel.getTabComponentAt(index)).setIcon(icon);
    }

    public void closeCurrentResultTab() {
        JComponent selectedTab = (JComponent)this._tabbedExecutionsPanel.getSelectedComponent();
        this._resultTabClosing.closeTab(selectedTab);
    }

    public void gotoNextResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int nextTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() + 1;
            if (nextTabIdx >= tabCount) {
                nextTabIdx = 0;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(nextTabIdx);
        }
    }

    public void gotoPreviousResultsTab() {
        int tabCount = this._tabbedExecutionsPanel.getTabCount();
        if (tabCount > 1) {
            int prevTabIdx = this._tabbedExecutionsPanel.getSelectedIndex() - 1;
            if (prevTabIdx < 0) {
                prevTabIdx = tabCount - 1;
            }
            this._tabbedExecutionsPanel.setSelectedIndex(prevTabIdx);
        }
    }

    protected String fireSQLToBeExecutedEvent(String sql) {
        ISQLExecutionListener[] listeners = this._sqlExecutionListeners.toArray(new ISQLExecutionListener[0]);
        for (int i = listeners.length - 1; i >= 0 && (sql = listeners[i].statementExecuting(sql)) != null; --i) {
        }
        return sql;
    }

    private void createSQLResultFrame(IResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        this._tabbedExecutionsPanel.remove(tab.getCompleteResultTab());
        ResultFrameListener resultFrameListener = new ResultFrameListener(){

            @Override
            public void frameReplaced(ResultFrame oldFrame, ResultFrame newFrame) {
                SQLResultExecutorPanel.this.onFrameReplaced(oldFrame, newFrame);
            }
        };
        ResultFrame frame = new ResultFrame(this._session, tab, this._resultTabFactory, resultFrameListener, true, false);
        this._sqlResultFrames.add(frame);
    }

    private void onFrameReplaced(ResultFrame oldFrame, ResultFrame newFrame) {
        this._sqlResultFrames.remove(oldFrame);
        this._sqlResultFrames.add(newFrame);
    }

    private void returnToTabbedPane(ResultTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        MarkDuplicatesChooserController resultFramesMarkDuplicatesChooserController = null;
        for (ResultFrame sqlResultFrame : this._sqlResultFrames) {
            if (tab != sqlResultFrame.getResultTab()) continue;
            resultFramesMarkDuplicatesChooserController = sqlResultFrame.getMarkDuplicatesChooserController();
            this._sqlResultFrames.remove(sqlResultFrame);
            break;
        }
        this.addResultsTab(tab, null);
        tab.wasReturnedToTabbedPane(resultFramesMarkDuplicatesChooserController);
        this._tabbedExecutionsPanel.setSelectedComponent(tab);
    }

    @Override
    public IResultTab getSelectedResultTab() {
        return (IResultTab)((Object)this._tabbedExecutionsPanel.getSelectedComponent());
    }

    @Override
    public void addCustomResult(CustomResultPanel resultPanel, String title, Icon icon) {
        this._tabbedExecutionsPanel.add(title, resultPanel);
        this._tabbedExecutionsPanel.setSelectedComponent(resultPanel);
        int selectedIndex = this._tabbedExecutionsPanel.getSelectedIndex();
        ButtonTabComponent tabComponent = new ButtonTabComponent(title, icon);
        tabComponent.getClosebutton().addActionListener(e -> this.onCustomTabClose(resultPanel));
        tabComponent.getToWindowButton().setVisible(false);
        this._tabbedExecutionsPanel.setTabComponentAt(selectedIndex, tabComponent);
        this.checkResultTabLimit();
    }

    @Override
    public List<IResultTab> getAllSqlResultTabs() {
        return this.getAllTabs().stream().filter(t -> t instanceof IResultTab).map(t -> (IResultTab)((Object)t)).collect(Collectors.toList());
    }

    private void onCustomTabClose(CustomResultPanel customResultPanel) {
        this._resultTabClosing.closeTab(customResultPanel);
    }

    private void onAddResultsTab(SQLExecutionInfo exInfo, ResultSetDataSet rsds, ResultSetMetaDataDataSet mdds, IDataSetUpdateableTableModel dataSetUpdateableTableModel, IResultTab resultTabToReplace) {
        try {
            ResultTab tab = this._resultTabFactory.createResultTab(exInfo, dataSetUpdateableTableModel, rsds, mdds);
            this.addResultsTab(tab, resultTabToReplace);
            this._tabbedExecutionsPanel.setSelectedComponent(tab);
        }
        catch (Throwable t) {
            this._session.showErrorMessage(t);
        }
    }

    private void onRemoveCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
        this._tabbedExecutionsPanel.remove(cancelPanelCtrl.getPanel());
        int indexToSelect = -1;
        indexToSelect = null == resultTabToReplace ? TabbedExcutionPanelUtil.getIndexOfTab(this._stickyTab, this._tabbedExecutionsPanel) : TabbedExcutionPanelUtil.getIndexOfTab(resultTabToReplace, this._tabbedExecutionsPanel);
        if (-1 != indexToSelect) {
            this._tabbedExecutionsPanel.setSelectedIndex(indexToSelect);
        }
        cancelPanelCtrl.wasRemoved();
    }

    private void onSetCancelPanel(final CancelPanelCtrl cancelPanelCtrl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLResultExecutorPanel.this._tabbedExecutionsPanel.addTab(i18n.EXEC_SQL_MSG, null, cancelPanelCtrl.getPanel(), i18n.CANCEL_SQL_MSG);
                SQLResultExecutorPanel.this._tabbedExecutionsPanel.setSelectedComponent(cancelPanelCtrl.getPanel());
            }
        });
    }

    private void addResultsTab(ResultTab tab, IResultTab resultTabToReplace) {
        boolean replaceStickyTab;
        TableState sortableTableState;
        if (null == resultTabToReplace && null == this._stickyTab) {
            this._tabbedExecutionsPanel.addTab(tab.getTitle(), null, tab, tab.getViewableSqlString());
            JLabel tabComponent = new JLabel(StringUtilities.shortenEnd(tab.getViewableSqlString(), 20, null));
            this._tabbedExecutionsPanel.setTabComponentAt(this._tabbedExecutionsPanel.indexOfComponent(tab), tabComponent);
            this.checkResultTabLimit();
            return;
        }
        if (null != resultTabToReplace && this._session.getProperties().getKeepTableLayoutOnRerun() && null != (sortableTableState = resultTabToReplace.getResultSortableTableState())) {
            tab.applyResultSortableTableState(sortableTableState);
        }
        int indexToReplace = -1;
        ImageIcon tabIcon = null;
        boolean bl = replaceStickyTab = null != this._stickyTab && (null == resultTabToReplace || this._stickyTab == resultTabToReplace);
        if (replaceStickyTab) {
            indexToReplace = TabbedExcutionPanelUtil.getIndexOfTab(this._stickyTab, this._tabbedExecutionsPanel);
            if (-1 == indexToReplace) {
                this._stickyTab = null;
            } else {
                tabIcon = this._tabIconManager.getStickyIcon();
                this._stickyTab = tab;
            }
        } else if (null != resultTabToReplace) {
            indexToReplace = TabbedExcutionPanelUtil.getIndexOfTab(resultTabToReplace, this._tabbedExecutionsPanel);
            if (this._resultTabClosing.isAnchored((JComponent)((Object)resultTabToReplace))) {
                tabIcon = this._tabIconManager.getAnchorIcon();
            }
        }
        if (-1 == indexToReplace) {
            this.addResultsTab(tab, null);
        } else {
            this._resultTabClosing.closeTabAt(indexToReplace);
            this._tabbedExecutionsPanel.insertTab(tab.getTitle(), tabIcon, tab, tab.getViewableSqlString(), indexToReplace);
            JLabel tabComponent = new JLabel(StringUtilities.shortenEnd(tab.getViewableSqlString(), 20, null));
            this._tabbedExecutionsPanel.setTabComponentAt(this._tabbedExecutionsPanel.indexOfComponent(tab), tabComponent);
            if (null != tabIcon) {
                this.setIconAt(indexToReplace, tabIcon);
            }
        }
    }

    private void checkResultTabLimit() {
        SessionProperties props = this._session.getProperties();
        int indexToRemove = 0;
        while (props.getLimitSQLResultTabs() && props.getSqlResultTabLimit() < this._tabbedExecutionsPanel.getTabCount() && !(this._tabbedExecutionsPanel.getComponentAt(indexToRemove) instanceof CancelPanel)) {
            if (this._resultTabClosing.isAnchoredAt(indexToRemove)) {
                ++indexToRemove;
            } else {
                this._resultTabClosing.closeTabAt(indexToRemove);
            }
            if (indexToRemove != this._tabbedExecutionsPanel.getTabCount() - 1) continue;
            break;
        }
    }

    private void propertiesHaveChanged(String propName) {
        SessionProperties props = this._session.getProperties();
        if (propName == null || propName.equals("autoCommit")) {
            SetSessionAutoCommitTask task = new SetSessionAutoCommitTask(this._session);
            if (SwingUtilities.isEventDispatchThread()) {
                this._session.getApplication().getThreadPool().addTask(task);
            } else {
                task.run();
            }
        }
        if (propName == null || propName.equals("sqlExecutionTabPlacement")) {
            this._tabbedExecutionsPanel.setTabPlacement(props.getSQLExecutionTabPlacement());
        }
    }

    private void createGUI() {
        SessionProperties props = this._session.getProperties();
        this._tabbedExecutionsPanel = UIFactory.getInstance().createTabbedPane(props.getSQLExecutionTabPlacement(), true);
        this.initTabPopup();
        GUIUtils.listenToMouseWheelClickOnTab(this._tabbedExecutionsPanel, (tabIndex, tabComponent) -> this.doCloseOnMiddleMouseClick(tabIndex));
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedExecutionsPanel, "Center");
    }

    private void doCloseOnMiddleMouseClick(int tabIndex) {
        Component comp = this._tabbedExecutionsPanel.getComponentAt(tabIndex);
        if (comp instanceof IResultTab || comp instanceof ErrorPanel || comp instanceof CustomResultPanel) {
            this._resultTabClosing.closeTab((JComponent)comp);
        }
    }

    private void initTabPopup() {
        JPopupMenu popup = new JPopupMenu();
        String closeLabel = s_stringMgr.getString("SQLResultExecuterPanel.close");
        JMenuItem mnuClose = new JMenuItem(closeLabel);
        this.initAccelerator(CloseCurrentSQLResultTabAction.class, mnuClose);
        mnuClose.addActionListener(e -> this.closeCurrentResultTab());
        popup.add(mnuClose);
        String cabtLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllButThis");
        JMenuItem mnuCloseAllButThis = new JMenuItem(cabtLabel);
        this.initAccelerator(CloseAllSQLResultTabsButCurrentAction.class, mnuCloseAllButThis);
        mnuCloseAllButThis.addActionListener(e -> this.closeAllButCurrentResultTabs());
        popup.add(mnuCloseAllButThis);
        String caLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAll");
        JMenuItem mnuCloseAll = new JMenuItem(caLabel);
        this.initAccelerator(CloseAllSQLResultTabsAction.class, mnuCloseAll);
        mnuCloseAll.addActionListener(e -> this.closeAllSQLResultTabs());
        popup.add(mnuCloseAll);
        String closeAlltoLeftLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllToLeft");
        JMenuItem mnuCloseAllToLeft = new JMenuItem(closeAlltoLeftLabel);
        this.initAccelerator(CloseAllSQLResultTabsToLeftAction.class, mnuCloseAllToLeft);
        mnuCloseAllToLeft.addActionListener(e -> this.closeAllToResultTabs(true));
        popup.add(mnuCloseAllToLeft);
        String closeAlltoRightLabel = s_stringMgr.getString("SQLResultExecuterPanel.closeAllToRight");
        JMenuItem mnuCloseAllToRight = new JMenuItem(closeAlltoRightLabel);
        this.initAccelerator(CloseAllSQLResultTabsToRightAction.class, mnuCloseAllToLeft);
        mnuCloseAllToRight.addActionListener(e -> this.closeAllToResultTabs(false));
        popup.add(mnuCloseAllToRight);
        String tsLabel = s_stringMgr.getString("SQLResultExecuterPanel.toggleSticky");
        JMenuItem mnuToggleSticky = new JMenuItem(tsLabel);
        this.initAccelerator(ToggleCurrentSQLResultTabStickyAction.class, mnuToggleSticky);
        mnuToggleSticky.addActionListener(e -> this.toggleCurrentSQLResultTabSticky());
        mnuToggleSticky.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.toggleSticky.tooltip"));
        popup.add(mnuToggleSticky);
        String taLabel = s_stringMgr.getString("SQLResultExecuterPanel.toggleAnchored");
        JMenuItem mnuToggleAnchored = new JMenuItem(taLabel);
        this.initAccelerator(ToggleCurrentSQLResultTabAnchoredAction.class, mnuToggleAnchored);
        mnuToggleAnchored.addActionListener(e -> this.toggleCurrentSQLResultTabAnchored());
        mnuToggleAnchored.setToolTipText(s_stringMgr.getString("SQLResultExecuterPanel.toggleAnchored.tooltip"));
        popup.add(mnuToggleAnchored);
        GUIUtils.listenToRightMouseClickOnTabComponent(this._tabbedExecutionsPanel, (tabIndex, tabComponent, clickPosX, clickPosY) -> popup.show(tabComponent, clickPosX, clickPosY));
    }

    private void initAccelerator(Class<? extends Action> actionClass, JMenuItem mnuItem) {
        Action action = this._session.getApplication().getActionCollection().get(actionClass);
        String accel = (String)action.getValue("SQuirreLAcceleratorString");
        Main.getApplication().getShortcutManager().setAccelerator(mnuItem, KeyStroke.getKeyStroke(accel), action);
    }

    static interface i18n {
        public static final String EXEC_SQL_MSG = s_stringMgr.getString("SQLResultExecuterPanel.exec");
        public static final String CANCEL_SQL_MSG = s_stringMgr.getString("SQLResultExecuterPanel.cancelMsg");
    }
}

