/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.io.File;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectCompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ReloadSqlContentsHelper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.changetrack.ChangeTrackTypeEnum;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionStartupMainSQLTabContentLoader {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionStartupMainSQLTabContentLoader.class);
    private static ILogger s_log = LoggerController.createLogger(ResultFrame.class);
    private static final String NO_STARTUP_LOADING = "Dummy marker to switch of standard startup loading.";

    static void handleLoadFileAtSessionStart(ISession session, ISQLPanelAPI panelAPI) {
        String sqlContents;
        if (NO_STARTUP_LOADING.equals(session.getSessionLocal(SessionStartupMainSQLTabContentLoader.class))) {
            return;
        }
        String startupFileForAlias = Main.getApplication().getRecentFilesManager().getOpenAtStartupFileForAlias(session.getAlias());
        if (null != startupFileForAlias) {
            File file = new File(startupFileForAlias);
            if (file.exists() && !file.isDirectory() && file.canRead()) {
                SwingUtilities.invokeLater(() -> SessionStartupMainSQLTabContentLoader.openFileInMainSqlTab(file, session.getSessionInternalFrame()));
                Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("SessionStartupMainSQLTabContentLoader.startupFileForAlias.loading", startupFileForAlias));
            } else {
                String msg = s_stringMgr.getString("SessionStartupMainSQLTabContentLoader.startupFileForAlias.load.failed", startupFileForAlias);
                Main.getApplication().getMessageHandler().showErrorMessage(msg);
                s_log.error(msg);
            }
        } else if (Main.getApplication().getSquirrelPreferences().isReloadSqlContents() && null != (sqlContents = ReloadSqlContentsHelper.getLastSqlContent(session.getAlias()))) {
            SwingUtilities.invokeLater(() -> SessionStartupMainSQLTabContentLoader.applyLastEditorContents(panelAPI, sqlContents));
        }
    }

    private static void applyLastEditorContents(ISQLPanelAPI panelAPI, String sqlContents) {
        panelAPI.setEntireSQLScript(sqlContents);
        panelAPI.resetUnsavedEdits();
        if (ChangeTrackTypeEnum.getPreference() == ChangeTrackTypeEnum.MANUAL) {
            panelAPI.getChangeTracker().rebaseChangeTrackingOnToolbarButtonOrMenuClicked();
        }
    }

    public static void startSessionWithFile(SQLAlias selectedAlias, final File fileToOpen) {
        ConnectCompletionCallback callback = new ConnectCompletionCallback(){

            @Override
            public void connected(ISQLConnection conn) {
            }

            @Override
            public void sessionCreated(ISession session) {
                session.putSessionLocal(SessionStartupMainSQLTabContentLoader.class, SessionStartupMainSQLTabContentLoader.NO_STARTUP_LOADING);
            }

            @Override
            public void sessionInternalFrameCreated(SessionInternalFrame sessionInternalFrame) {
                SessionStartupMainSQLTabContentLoader.onSessionInternalFrameCreated(sessionInternalFrame, fileToOpen);
            }

            @Override
            public void errorOccurred(Throwable th, boolean stopConnection) {
            }
        };
        new ConnectToAliasCommand(selectedAlias, true, callback).executeConnect();
    }

    private static void onSessionInternalFrameCreated(SessionInternalFrame sessionInternalFrame, File fileToOpen) {
        SwingUtilities.invokeLater(() -> SessionStartupMainSQLTabContentLoader.openFileInMainSqlTab(fileToOpen, sessionInternalFrame));
    }

    private static void openFileInMainSqlTab(File file, SessionInternalFrame sessionInternalFrame) {
        sessionInternalFrame.getMainSQLPanelAPI().getFileHandler().fileOpen(file);
        sessionInternalFrame.setMainSqlFile(file);
    }
}

