/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SetSessionAutoCommitTask
implements Runnable {
    private static final ILogger s_log = LoggerController.createLogger(SetSessionAutoCommitTask.class);
    private ISession _session;

    public SetSessionAutoCommitTask(ISession session) {
        this._session = session;
    }

    @Override
    public void run() {
        ISQLConnection conn = this._session.getSQLConnection();
        SessionProperties props = this._session.getProperties();
        if (conn != null) {
            boolean auto = true;
            try {
                auto = conn.getAutoCommit();
            }
            catch (Exception ex) {
                s_log.error("Error with transaction control", ex);
                this._session.showErrorMessage(ex);
            }
            try {
                this._session.getConnectionPool().setSessionAutoCommit(props.getAutoCommit());
            }
            catch (Exception ex) {
                props.setAutoCommit(auto);
                this._session.showErrorMessage(ex);
            }
        }
    }
}

