/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlHistoryListener;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;

public class SqlListenerService {
    private final ISession _session;
    private final SqlHistoryListener _sqlHistoryListener;
    private final List<ISQLExecutionListener> _sqlExecutionListeners = new ArrayList<ISQLExecutionListener>();

    public SqlListenerService(ISession session, SqlHistoryListener sqlHistoryListener) {
        this._session = session;
        this._sqlHistoryListener = sqlHistoryListener;
        this._sqlExecutionListeners.add(new SQLExecutionAdapter(){

            @Override
            public void statementExecuted(QueryHolder queryHolder) {
                SqlListenerService.this.addSQLToHistory(queryHolder.getOriginalQuery());
            }
        });
        Main.getApplication().getSQLHistory().addSQLHistoryListener(this._sqlHistoryListener);
        this._sqlExecutionListeners.add(new SQLExecutionAdapter(){

            @Override
            public void statementExecuted(QueryHolder queryHolder) {
                SqlListenerService.this._session.getConnectionPool().sqlStatementExecuted(queryHolder);
            }
        });
    }

    private void addSQLToHistory(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql == null");
        }
        SQLHistoryItem shi = new SQLHistoryItem(sql, this._session.getAlias().getName());
        if (this._session.getProperties().getSQLShareHistory()) {
            Main.getApplication().getSQLHistory().addSQLHistoryItem(shi);
            Main.getApplication().savePreferences(PreferenceType.SQLHISTORY);
        } else {
            this._sqlHistoryListener.newSqlHistoryItem(shi);
        }
    }

    public List<ISQLExecutionListener> getSqlExecutionListeners() {
        return this._sqlExecutionListeners;
    }

    public void close() {
        Main.getApplication().getSQLHistory().removeSQLHistoryListener(this._sqlHistoryListener);
    }
}

